package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant;

/**
 * 收支类型
 *
 * @author 即墨 Date 2021-08-31
 */
public enum IncomeExpenditureEnum {

    /**
     * 收支类型
     */
    INCOME("01", "收入"),
    EXPENDITURE("02", "支出"),
    ;

    private final String code;
    private final String name;

    IncomeExpenditureEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static IncomeExpenditureEnum fromCode(String code) {
        for (IncomeExpenditureEnum typeEnum : IncomeExpenditureEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        IncomeExpenditureEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        IncomeExpenditureEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public String toName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
