package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant;

/**
 * 开关
 * @author 即墨
 * Date 2021-08-31
 */
public enum SwitchEnum {

    /**
     * 开关
     */
    ON("01", "开"),
    OFF("02", "关"),
    ;

    private final String code;
    private final String name;

    SwitchEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static SwitchEnum fromCode(String code) {
        for (SwitchEnum typeEnum : SwitchEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        SwitchEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        SwitchEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public String toName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
