package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant;

/**
 * 交易类型
 *
 * @author 即墨 Date 2021-08-31
 */
public enum TradeTypeEnum {

  /** 交易类型 */
  ORDER_REBATE("01", "下单赠送"),
  ORDER_DEDUCT("02", "订单抵扣"),
  ORDER_RETUNN("03", "订单退回"),
  RETURN_DEDUCT("04", "退货扣减"),
  QUOTA_ISSUANCE("05", "预支额度发放"),
  QUOTA_RETURN("06", "预支额度归还"),
  GIVE_RETURN("07", "赠送退回"),
  MANUAL_IMPORT("08", "人工导入"),
  MANUAL_ADJUST("09", "手工调整"),
  ;
  private final String code;
  private final String name;

  TradeTypeEnum(String code, String name) {
    this.code = code;
    this.name = name;
  }

  public static TradeTypeEnum fromCode(String code) {
    for (TradeTypeEnum typeEnum : TradeTypeEnum.values()) {
      if (typeEnum.getCode().equals(code)) {
        return typeEnum;
      }
    }
    return null;
  }

  public static String toCode(String status) {
    TradeTypeEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getCode();
  }

  public static String toName(String status) {
    TradeTypeEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getName();
  }

  public String toName() {
    return name;
  }

  public String getCode() {
    return code;
  }

  public String getName() {
    return name;
  }
}
