package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant;

/**
 * 返利账号用户类型
 *
 * @author sumo
 * @date 2021/6/17
 */
public enum UserTypeEnum {

    /**
     * CUSTOMER
     */
    CUSTOMER("CUSTOMER", "客户"),
    ;

    private String code;
    private String name;

    UserTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static UserTypeEnum fromCode(String code) {
        for (UserTypeEnum typeEnum : UserTypeEnum.values()) {
            if (typeEnum.toCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public String toName() {
        return name;
    }

    public String toCode() {
        return code;
    }

}
