/*
 * @(#)AdvanceModeEnum.java 1.0 2021年09月29日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums;

/**
 * <p>Title:AdvanceModeEnum</p>
 * <p>Description: 发货方式 01：定时发放， 02：立即发放 </p>
 *
 * @author 顼阳
 * @date 2021/9/29 11:56 上午
 * @since 0.1.0
 */
public enum AdvanceModeEnum {

    /** 交易类型 */
    FIXED_TIME("01", "定时发放"),
    IMMEDIATELY("02", "立即发放"),
    ;

    private final String code;
    private final String name;

    AdvanceModeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static AdvanceModeEnum fromCode(String code) {
        for (AdvanceModeEnum typeEnum : AdvanceModeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        AdvanceModeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        AdvanceModeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public String toName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
