/*
 * @(#)AdvanceStatusEnum.java 1.0 2021年09月22日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums;

/**
 * Title:AdvanceStatusEnum
 *
 * <p>Description: 预支状态
 *
 * @author 顼阳
 * @date 2021/9/22 1:44 下午
 * @since 0.1.0
 */
public enum AdvanceStatusEnum {
  /** 交易类型 */
  IS_SEND("01", "待发放"),
  WAIT_RETURN("02", "待归还"),
  ALEADY_RETURN("03", "已归还"),
  NO_RETURN("04", "无需归还"),
  ;

  private final String code;
  private final String name;

  AdvanceStatusEnum(String code, String name) {
    this.code = code;
    this.name = name;
  }

  public static AdvanceStatusEnum fromCode(String code) {
    for (AdvanceStatusEnum typeEnum : AdvanceStatusEnum.values()) {
      if (typeEnum.getCode().equals(code)) {
        return typeEnum;
      }
    }
    return null;
  }

  public static String toCode(String status) {
    AdvanceStatusEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getCode();
  }

  public static String toName(String status) {
    AdvanceStatusEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getName();
  }

  public String toName() {
    return name;
  }

  public String getCode() {
    return code;
  }

  public String getName() {
    return name;
  }
}
