/*
 * @(#)AmountTypeEnum.java 1.0 2021年09月22日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums;

/**
 * Title:AmountTypeEnum
 *
 * <p>Description:金额类型
 *
 * @author 顼阳
 * @date 2021/9/22 2:08 下午
 * @since 0.1.0
 */
public enum AmountTypeEnum {
  /** 交易类型 */
  PRODUCT_AMOUNT("01", "产品金额"),
  SCALE_AMOUNT("02", "产品折让后金额"),
  ;
  private final String code;
  private final String name;

  AmountTypeEnum(String code, String name) {
    this.code = code;
    this.name = name;
  }

  public static AmountTypeEnum fromCode(String code) {
    for (AmountTypeEnum typeEnum : AmountTypeEnum.values()) {
      if (typeEnum.getCode().equals(code)) {
        return typeEnum;
      }
    }
    return null;
  }

  public static String toCode(String status) {
    AmountTypeEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getCode();
  }

  public static String toName(String status) {
    AmountTypeEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getName();
  }

  public String toName() {
    return name;
  }

  public String getCode() {
    return code;
  }

  public String getName() {
    return name;
  }
}
