package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums;

import com.dtyunxi.exceptions.BizException;

public enum BalanceExceptionEnum {
    CHECK_PARAM_NOT_NULL("10001", "入参'%s'不允许为空"),
    DATA_NOT_NULL("10002", "'%s'为空"),
    DATA_NOT_EXIST("10003", "'%s'不存在");

    private String code;
    private String msg;

    BalanceExceptionEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public BizException buildBizException(String... formats) {
        throw new BizException(this.code, String.format(this.msg, formats));
    }
}
