/*
 * @(#)AdvanceStatusEnum.java 1.0 2021年09月22日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums;

/**
 * Title:AdvanceStatusEnum
 *
 * <p>Description: 预支状态
 *
 * @author 顼阳
 * @date 2021/9/22 1:44 下午
 * @since 0.1.0
 */
public enum FreezeStatusEnum {
  /** 交易类型 */
  FREEZEING("01", "冻结中"),
  UNFREEZE("02", "已解冻"),
  ;

  private final String code;
  private final String name;

  FreezeStatusEnum(String code, String name) {
    this.code = code;
    this.name = name;
  }

  public static FreezeStatusEnum fromCode(String code) {
    for (FreezeStatusEnum typeEnum : FreezeStatusEnum.values()) {
      if (typeEnum.getCode().equals(code)) {
        return typeEnum;
      }
    }
    return null;
  }

  public static String toCode(String status) {
    FreezeStatusEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getCode();
  }

  public static String toName(String status) {
    FreezeStatusEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getName();
  }

  public String toName() {
    return name;
  }

  public String getCode() {
    return code;
  }

  public String getName() {
    return name;
  }
}
