/*
 * @(#)FreezeTypeEnum.java 1.0 2021年09月22日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums;

/**
 * <p>Title:FreezeTypeEnum</p>
 * <p>Description: </p>
 *
 * @author 顼阳
 * @date 2021/9/22 1:51 下午
 * @since 0.1.0
 */
public enum FreezeTypeEnum {

    /** 交易类型 */
    THIS_USE("01", "赠送额度本单使用"),
            ;
    private final String code;
    private final String name;

    FreezeTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static FreezeTypeEnum fromCode(String code) {
        for (FreezeTypeEnum typeEnum : FreezeTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        FreezeTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        FreezeTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public String toName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
