/*
 * @(#)GiftTypeEnum.java 1.0 2021年09月22日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums;

/**
 * Title:GiftTypeEnum
 *
 * <p>Description: 赠送类型
 *
 * @author 顼阳
 * @date 2021/9/22 2:08 下午
 * @since 0.1.0
 */
public enum GiftTypeEnum {

  /** 交易类型 */
  AMOUNT_GIVE("01", "下单产品金额比例赠送"),
  SUM_GIVE("02", "按下单产品数量赠送"),
  ;
  private final String code;
  private final String name;

  GiftTypeEnum(String code, String name) {
    this.code = code;
    this.name = name;
  }

  public static GiftTypeEnum fromCode(String code) {
    for (GiftTypeEnum typeEnum : GiftTypeEnum.values()) {
      if (typeEnum.getCode().equals(code)) {
        return typeEnum;
      }
    }
    return null;
  }

  public static String toCode(String status) {
    GiftTypeEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getCode();
  }

  public static String toName(String status) {
    GiftTypeEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getName();
  }

  public String toName() {
    return name;
  }

  public String getCode() {
    return code;
  }

  public String getName() {
    return name;
  }
}
