/*
 * @(#)SendBackEnum.java 1.0 2021年09月22日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;

/**
 * Title:SendBackEnum
 *
 * <p>Description:是否需要归还
 *
 * @author 顼阳
 * @date 2021/9/22 11:24 上午
 * @since 0.1.0
 */
public enum SendBackEnum {

  /** 交易类型 */
  YES("01", "是"),
  NO("02", "否"),
  ;
  private final String code;
  private final String name;

  SendBackEnum(String code, String name) {
    this.code = code;
    this.name = name;
  }

  public static SendBackEnum fromName(String name) {
    for (SendBackEnum typeEnum : SendBackEnum.values()) {
      if (typeEnum.getName().equals(name)) {
        return typeEnum;
      }
    }
    return null;
  }

  public static SendBackEnum fromCode(String code) {
    for (SendBackEnum typeEnum : SendBackEnum.values()) {
      if (typeEnum.getCode().equals(code)) {
        return typeEnum;
      }
    }
    return null;
  }

  public static String toCode(String status) {
    SendBackEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getCode();
  }

  public static String toName(String status) {
    SendBackEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getName();
  }

  public static String nameToCode(String name) {
    SendBackEnum newEnum = fromName(name);
    return newEnum == null ? null : newEnum.getCode();
  }

  public String toName() {
    return name;
  }

  public String getCode() {
    return code;
  }

  public String getName() {
    return name;
  }
}
