package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftBalanceAdjustTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Data
public class AdjustGiftBalanceReqDto extends BaseVo {
    /**
     * 免费额度账户id不能为空
     */
    @ApiModelProperty(value = "免费额度账户id")
    @NotNull(message = "免费额度账户id不能为空")
    private Long id;

    /**
     * 客户编号
     */
    @ApiModelProperty(value = "客户编号")
    private String customerCode;

    /**
     * @see GiftBalanceAdjustTypeEnum
     * 调整类型：1.增加，2.减少
     */
    @ApiModelProperty(value = "GiftBalanceAdjustTypeEnum-调整类型：1.增加，2.减少")
    @NotNull(message = "调整类型不能为空")
    private Integer adjustType;

    /**
     * 调整额度
     */
    @ApiModelProperty(value = "调整额度")
    @NotNull(message = "调整额度不能为空")
    private BigDecimal adjustAmount;

    @ApiModelProperty(value = "备注说明")
    private String adjustRemark;

    private TradeTypeEnum tradeTypeEnum = TradeTypeEnum.MANUAL_ADJUST;

}
