/*
 * @(#)BalanceAdvanceAddReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.AdvanceModeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.SendBackEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Title:BalanceAdvanceAddReqDto
 *
 * <p>Description: 预支额度新增请求参数
 *
 * @author 顼阳
 * @date 2021/9/19 8:14 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceAdvanceAddReqDto", description = "预支额度新增请求参数")
public class BalanceAdvanceAddReqDto {

  @ApiModelProperty(value = "客户id")
  @NotNull(message = "不能为空")
  private Long customerId;

  @ApiModelProperty(value = "预支时间")
  private Date advanceTime;

  @ApiModelProperty(value = "预支额度(元)")
  private BigDecimal advanceAmount;

  @ApiModelProperty(value = "额度发放时间 FIXED_TIME:定时发放, IMMEDIATELY:立即发放")
  private AdvanceModeEnum advanceModeEnum;

  @ApiModelProperty(value = "定时发放时间(元)")
  private Date advanceGrantTime;

  @ApiModelProperty(value = "是否需要归还 YES:是, NO:否")
  private SendBackEnum sendBackEnum;

  @ApiModelProperty(value = "额度归还时间")
  private Date advanceSendBackTime;

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public Date getAdvanceTime() {
    return advanceTime;
  }

  public void setAdvanceTime(Date advanceTime) {
    this.advanceTime = advanceTime;
  }

  public BigDecimal getAdvanceAmount() {
    return advanceAmount;
  }

  public void setAdvanceAmount(BigDecimal advanceAmount) {
    this.advanceAmount = advanceAmount;
  }

  public AdvanceModeEnum getAdvanceModeEnum() {
    return advanceModeEnum;
  }

  public void setAdvanceModeEnum(AdvanceModeEnum advanceModeEnum) {
    this.advanceModeEnum = advanceModeEnum;
  }

  public Date getAdvanceGrantTime() {
    return advanceGrantTime;
  }

  public void setAdvanceGrantTime(Date advanceGrantTime) {
    this.advanceGrantTime = advanceGrantTime;
  }

  public SendBackEnum getSendBackEnum() {
    return sendBackEnum;
  }

  public void setSendBackEnum(SendBackEnum sendBackEnum) {
    this.sendBackEnum = sendBackEnum;
  }

  public Date getAdvanceSendBackTime() {
    return advanceSendBackTime;
  }

  public void setAdvanceSendBackTime(Date advanceSendBackTime) {
    this.advanceSendBackTime = advanceSendBackTime;
  }

  @Override
  public String toString() {
    return "BalanceAdvanceAddReqDto{" +
            "customerId=" + customerId +
            ", advanceTime=" + advanceTime +
            ", advanceAmount=" + advanceAmount +
            ", advanceModeEnum=" + advanceModeEnum +
            ", advanceGrantTime=" + advanceGrantTime +
            ", sendBackEnum=" + sendBackEnum +
            ", advanceSendBackTime=" + advanceSendBackTime +
            '}';
  }
}
