/*
 * @(#)BalanceAdvanceQueryReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.AdvanceStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.SendBackEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * Title:BalanceAdvanceQueryReqDto
 *
 * <p>Description: 预支额度
 *
 * @author 顼阳
 * @date 2021/9/19 8:20 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceAdvanceAddReqDto", description = "预支额度列出查询请求参数")
public class BalanceAdvanceQueryReqDto {
  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "状态 IS_SEND:待发放,WAIT_RETURN:待归还,ALEADY_RETURN:已归还,NO_RETURN:无需归还")
  private AdvanceStatusEnum advanceStatusEnum;

  @ApiModelProperty(value = "预支单号")
  private String advanceNo;

  @ApiModelProperty(value = "额度发放时间(元)开始")
  private Date advanceGrantTimeStart;

  @ApiModelProperty(value = "额度发放时间(元)结束")
  private Date advanceGrantTimeEnd;

  @ApiModelProperty(value = "额度归还时间(元)开始")
  private Date advanceSendBackTimeStart;

  @ApiModelProperty(value = "额度归还时间(元)结束")
  private Date advanceSendBackTimeEnd;

  @ApiModelProperty(value = "是否需要归还 YES:是, NO:否")
  private SendBackEnum sendBackEnum;

  @ApiModelProperty(value = "预支时间开始")
  private Date advanceTimeStart;

  @ApiModelProperty(value = "预支时间结束")
  private Date advanceTimeEnd;

  @ApiModelProperty(value = "组织id")
  private Long organizationId;

  @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
  private int pageSize = 10;

  @ApiModelProperty(name = "pageNum", value = "页码，选填")
  private int pageNum = 1;

  @ApiModelProperty(value = "用户id")
  private Long userId;

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public AdvanceStatusEnum getAdvanceStatusEnum() {
    return advanceStatusEnum;
  }

  public void setAdvanceStatusEnum(AdvanceStatusEnum advanceStatusEnum) {
    this.advanceStatusEnum = advanceStatusEnum;
  }

  public String getAdvanceNo() {
    return advanceNo;
  }

  public void setAdvanceNo(String advanceNo) {
    this.advanceNo = advanceNo;
  }

  public Date getAdvanceGrantTimeStart() {
    return advanceGrantTimeStart;
  }

  public void setAdvanceGrantTimeStart(Date advanceGrantTimeStart) {
    this.advanceGrantTimeStart = advanceGrantTimeStart;
  }

  public Date getAdvanceGrantTimeEnd() {
    return advanceGrantTimeEnd;
  }

  public void setAdvanceGrantTimeEnd(Date advanceGrantTimeEnd) {
    this.advanceGrantTimeEnd = advanceGrantTimeEnd;
  }

  public Date getAdvanceSendBackTimeStart() {
    return advanceSendBackTimeStart;
  }

  public void setAdvanceSendBackTimeStart(Date advanceSendBackTimeStart) {
    this.advanceSendBackTimeStart = advanceSendBackTimeStart;
  }

  public Date getAdvanceSendBackTimeEnd() {
    return advanceSendBackTimeEnd;
  }

  public void setAdvanceSendBackTimeEnd(Date advanceSendBackTimeEnd) {
    this.advanceSendBackTimeEnd = advanceSendBackTimeEnd;
  }

  public SendBackEnum getSendBackEnum() {
    return sendBackEnum;
  }

  public void setSendBackEnum(SendBackEnum sendBackEnum) {
    this.sendBackEnum = sendBackEnum;
  }

  public Date getAdvanceTimeStart() {
    return advanceTimeStart;
  }

  public void setAdvanceTimeStart(Date advanceTimeStart) {
    this.advanceTimeStart = advanceTimeStart;
  }

  public Date getAdvanceTimeEnd() {
    return advanceTimeEnd;
  }

  public void setAdvanceTimeEnd(Date advanceTimeEnd) {
    this.advanceTimeEnd = advanceTimeEnd;
  }

  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  public int getPageSize() {
    return pageSize;
  }

  public void setPageSize(int pageSize) {
    this.pageSize = pageSize;
  }

  public int getPageNum() {
    return pageNum;
  }

  public void setPageNum(int pageNum) {
    this.pageNum = pageNum;
  }

  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @Override
  public String toString() {
    return "BalanceAdvanceQueryReqDto{" +
            "customerId=" + customerId +
            ", customerName='" + customerName + '\'' +
            ", customerCode='" + customerCode + '\'' +
            ", advanceStatusEnum=" + advanceStatusEnum +
            ", advanceNo='" + advanceNo + '\'' +
            ", advanceGrantTimeStart=" + advanceGrantTimeStart +
            ", advanceGrantTimeEnd=" + advanceGrantTimeEnd +
            ", advanceSendBackTimeStart=" + advanceSendBackTimeStart +
            ", advanceSendBackTimeEnd=" + advanceSendBackTimeEnd +
            ", sendBackEnum=" + sendBackEnum +
            ", advanceTimeStart=" + advanceTimeStart +
            ", advanceTimeEnd=" + advanceTimeEnd +
            ", organizationId=" + organizationId +
            ", pageSize=" + pageSize +
            ", pageNum=" + pageNum +
            ", userId=" + userId +
            '}';
  }
}
