/*
 * @(#)BalanceFreezeAddReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.FreezeStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.FreezeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Title:BalanceFreezeAddReqDto
 *
 * <p>Description: 冻结额度新增请求参数
 *
 * @author 顼阳
 * @date 2021/9/19 8:14 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceFreezeAddReqDto", description = "冻结额度新增请求参数")
public class BalanceFreezeAddReqDto {

  @ApiModelProperty(value = "客户id")
  @NotNull(message = "不能为空")
  private Long customerId;

  @ApiModelProperty(value = "冻结时间")
  private Date freezeTime;

  @ApiModelProperty(value = "冻结额度(元)")
  private BigDecimal freezeAmount;

  @ApiModelProperty(value = "冻结类型 THIS_USE:赠送额度本单使用")
  @NotNull(message = "不能为空")
  private FreezeTypeEnum freezeTypeEnum;

  @ApiModelProperty(value = "业务单号")
  @NotNull(message = "不能为空")
  private String businessNo;

  @ApiModelProperty(value = "解冻时间")
  private Date unFreezeTime;

  @ApiModelProperty(value = "状态 FREEZEING:冻结中, UNFREEZE:已解冻")
  @NotNull(message = "不能为空")
  private FreezeStatusEnum statusEnum;

  @ApiModelProperty(value = "冻结原因")
  private String reason;

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public Date getFreezeTime() {
    return freezeTime;
  }

  public void setFreezeTime(Date freezeTime) {
    this.freezeTime = freezeTime;
  }

  public BigDecimal getFreezeAmount() {
    return freezeAmount;
  }

  public void setFreezeAmount(BigDecimal freezeAmount) {
    this.freezeAmount = freezeAmount;
  }

  public FreezeTypeEnum getFreezeTypeEnum() {
    return freezeTypeEnum;
  }

  public void setFreezeTypeEnum(FreezeTypeEnum freezeTypeEnum) {
    this.freezeTypeEnum = freezeTypeEnum;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }

  public Date getUnFreezeTime() {
    return unFreezeTime;
  }

  public void setUnFreezeTime(Date unFreezeTime) {
    this.unFreezeTime = unFreezeTime;
  }

  public FreezeStatusEnum getStatusEnum() {
    return statusEnum;
  }

  public void setStatusEnum(FreezeStatusEnum statusEnum) {
    this.statusEnum = statusEnum;
  }

  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }
}
