/*
 * @(#)BalanceFreezeQueryReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.FreezeStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.FreezeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * Title:BalanceFreezeQueryReqDto
 *
 * <p>Description: 冻结额度列表查询请求参数
 *
 * @author 顼阳
 * @date 2021/9/19 8:20 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceFreezeAddReqDto", description = "冻结额度列表查询请求参数")
public class BalanceFreezeQueryReqDto {
  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "冻结类型 THIS_USE:赠送额度本单使用")
  private FreezeTypeEnum freezeTypeEnum;

  @ApiModelProperty(value = "业务单号")
  private String businessNo;

  @ApiModelProperty(value = "冻结状态 FREEZEING:冻结中, UNFREEZE:已解冻")
  private FreezeStatusEnum freezeStatusEnum;

  @ApiModelProperty(value = "冻结开始时间")
  private Date freezeTimeStart;

  @ApiModelProperty(value = "冻结结束时间")
  private Date freezeTimeEnd;

  @ApiModelProperty(value = "组织id")
  private Long organizationId;

  @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
  private int pageSize = 10;

  @ApiModelProperty(name = "pageNum", value = "页码，选填")
  private int pageNum = 1;

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public FreezeTypeEnum getFreezeTypeEnum() {
    return freezeTypeEnum;
  }

  public void setFreezeTypeEnum(FreezeTypeEnum freezeTypeEnum) {
    this.freezeTypeEnum = freezeTypeEnum;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }

  public FreezeStatusEnum getFreezeStatusEnum() {
    return freezeStatusEnum;
  }

  public void setFreezeStatusEnum(FreezeStatusEnum freezeStatusEnum) {
    this.freezeStatusEnum = freezeStatusEnum;
  }

  public Date getFreezeTimeStart() {
    return freezeTimeStart;
  }

  public void setFreezeTimeStart(Date freezeTimeStart) {
    this.freezeTimeStart = freezeTimeStart;
  }

  public Date getFreezeTimeEnd() {
    return freezeTimeEnd;
  }

  public void setFreezeTimeEnd(Date freezeTimeEnd) {
    this.freezeTimeEnd = freezeTimeEnd;
  }

  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  public int getPageSize() {
    return pageSize;
  }

  public void setPageSize(int pageSize) {
    this.pageSize = pageSize;
  }

  public int getPageNum() {
    return pageNum;
  }

  public void setPageNum(int pageNum) {
    this.pageNum = pageNum;
  }
}
