/*
 * @(#)BalanceQueryReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GivePriceTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiveTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.SwitchEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 余额账号列表查询对象
 *
 * @author 即墨 Date 2021-09-01
 */
@ApiModel(value = "BalanceQueryReqDto", description = "余额账号列表查询对象")
public class BalanceQueryReqDto implements Serializable {

  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "免费赠送 ON:开, OFF:关")
  private SwitchEnum giveFlagEnum;

  @ApiModelProperty(value ="赠送类型 AMOUNT_OF_MONEY:按下单金额比例赠送, PROPORTION:按下单数量比例赠送")
  private GiveTypeEnum giveTypeEnum;

  @ApiModelProperty(value = "金额类型 ORIGINAL_PRICE:产品金额, DISCOUNT_PRICE:产品折让后金额")
  private GivePriceTypeEnum givePriceTypeEnum;

  @ApiModelProperty(value = "组织id")
  private Long organizationId;

  @ApiModelProperty(value = "用户id")
  private Long userId;

  @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
  private int pageSize = 10;

  @ApiModelProperty(name = "pageNum", value = "页码，选填")
  private int pageNum = 1;

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public SwitchEnum getGiveFlagEnum() {
    return giveFlagEnum;
  }

  public void setGiveFlagEnum(SwitchEnum giveFlagEnum) {
    this.giveFlagEnum = giveFlagEnum;
  }

  public GiveTypeEnum getGiveTypeEnum() {
    return giveTypeEnum;
  }

  public void setGiveTypeEnum(GiveTypeEnum giveTypeEnum) {
    this.giveTypeEnum = giveTypeEnum;
  }

  public GivePriceTypeEnum getGivePriceTypeEnum() {
    return givePriceTypeEnum;
  }

  public void setGivePriceTypeEnum(GivePriceTypeEnum givePriceTypeEnum) {
    this.givePriceTypeEnum = givePriceTypeEnum;
  }

  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  public int getPageSize() {
    return pageSize;
  }

  public void setPageSize(int pageSize) {
    this.pageSize = pageSize;
  }

  public int getPageNum() {
    return pageNum;
  }

  public void setPageNum(int pageNum) {
    this.pageNum = pageNum;
  }

  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @Override
  public String toString() {
    return new StringBuffer("BalanceQueryReqDto{").append(
            "customerId=").append( customerId).append(
            ", customerName='").append( customerName).append( '\'').append(
            ", customerCode='").append( customerCode).append( '\'').append(
            ", giveFlagEnum=").append( giveFlagEnum).append(
            ", giveTypeEnum=").append( giveTypeEnum).append(
            ", givePriceTypeEnum=").append( givePriceTypeEnum).append(
            ", organizationId=").append( organizationId).append(
            ", userId=").append( userId).append(
            ", pageSize=").append( pageSize).append(
            ", pageNum=").append( pageNum).append(
            '}').toString();
  }
}
