/*
 * @(#)BalanceRecordAddReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.AmountTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.GiftTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Title:BalanceRecordAddReqDto
 *
 * <p>Description: 赠送记录新增请求参数
 *
 * @author 顼阳
 * @date 2021/9/19 8:14 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceRecordAddReqDto", description = "赠送记录新增请求参数")
public class BalanceRecordAddReqDto {

  @ApiModelProperty(value = "客户id")
  @NotNull(message = "不能为空")
  private Long customerId;

  @ApiModelProperty(value = "订单号")
  @NotNull(message = "不能为空")
  private String orderNo;

  @ApiModelProperty(value = "赠送类型 AMOUNT_GIVE:下单产品金额比例赠送, SUM_GIVE:按下单产品数量赠送")
  @NotNull(message = "不能为空")
  private GiftTypeEnum giftTypeEnum;

  @ApiModelProperty(value = "金额类型PRODUCT_AMOUNT:产品金额,SCALE_AMOUNT:产品折让后金额")
  @NotNull(message = "不能为空")
  private AmountTypeEnum amountTypeEnum;

  @ApiModelProperty(value = "赠送时间")
  private Date giftTime;

  @ApiModelProperty(value = "换算数量")
  private BigDecimal quantityScaleSum;

  @ApiModelProperty(value = "换算金额")
  private BigDecimal quantityScaleAmount;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "赠送比例")
  private BigDecimal giftScale;

  @ApiModelProperty(value = "产品数量")
  private Integer productCount;

  @ApiModelProperty(value = "赠送额度(元)")
  private BigDecimal giftAmount;

  @ApiModelProperty(value = "产品折扣后金额")
  private BigDecimal productRebateAmount;

  @ApiModelProperty(value = "产品金额")
  private BigDecimal productAmount;

  @ApiModelProperty(value = "满减/满折活动立减/折扣金额(元)")
  private BigDecimal discountAmount;

  @ApiModelProperty(value = "满赠活动产品金额(元)")
  private BigDecimal discountProductAmount;

  @ApiModelProperty(value = "折扣账户抵扣金额(元)")
  private BigDecimal rabateAccountProductAmount;

  @ApiModelProperty(value = "赠送记录明细")
  private List<BalanceRecordDetailAddReqDto> details;

  public BigDecimal getRabateAccountProductAmount() {
    return rabateAccountProductAmount;
  }

  public void setRabateAccountProductAmount(BigDecimal rabateAccountProductAmount) {
    this.rabateAccountProductAmount = rabateAccountProductAmount;
  }

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  public GiftTypeEnum getGiftTypeEnum() {
    return giftTypeEnum;
  }

  public void setGiftTypeEnum(GiftTypeEnum giftTypeEnum) {
    this.giftTypeEnum = giftTypeEnum;
  }

  public AmountTypeEnum getAmountTypeEnum() {
    return amountTypeEnum;
  }

  public void setAmountTypeEnum(AmountTypeEnum amountTypeEnum) {
    this.amountTypeEnum = amountTypeEnum;
  }

  public Date getGiftTime() {
    return giftTime;
  }

  public void setGiftTime(Date giftTime) {
    this.giftTime = giftTime;
  }

  public BigDecimal getQuantityScaleSum() {
    return quantityScaleSum;
  }

  public void setQuantityScaleSum(BigDecimal quantityScaleSum) {
    this.quantityScaleSum = quantityScaleSum;
  }

  public BigDecimal getQuantityScaleAmount() {
    return quantityScaleAmount;
  }

  public void setQuantityScaleAmount(BigDecimal quantityScaleAmount) {
    this.quantityScaleAmount = quantityScaleAmount;
  }

  public List<BalanceRecordDetailAddReqDto> getDetails() {
    return details;
  }

  public void setDetails(List<BalanceRecordDetailAddReqDto> details) {
    this.details = details;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public BigDecimal getGiftScale() {
    return giftScale;
  }

  public void setGiftScale(BigDecimal giftScale) {
    this.giftScale = giftScale;
  }


  public Integer getProductCount() {
    return productCount;
  }

  public void setProductCount(Integer productCount) {
    this.productCount = productCount;
  }

  public BigDecimal getGiftAmount() {
    return giftAmount;
  }

  public void setGiftAmount(BigDecimal giftAmount) {
    this.giftAmount = giftAmount;
  }

  public BigDecimal getProductRebateAmount() {
    return productRebateAmount;
  }

  public void setProductRebateAmount(BigDecimal productRebateAmount) {
    this.productRebateAmount = productRebateAmount;
  }

  public BigDecimal getProductAmount() {
    return productAmount;
  }

  public void setProductAmount(BigDecimal productAmount) {
    this.productAmount = productAmount;
  }

  public BigDecimal getDiscountAmount() {
    return discountAmount;
  }

  public void setDiscountAmount(BigDecimal discountAmount) {
    this.discountAmount = discountAmount;
  }

  public BigDecimal getDiscountProductAmount() {
    return discountProductAmount;
  }

  public void setDiscountProductAmount(BigDecimal discountProductAmount) {
    this.discountProductAmount = discountProductAmount;
  }
}
