/*
 * @(#)BalanceRecordAddReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * Title:BalanceRecordAddReqDto
 *
 * <p>Description: 赠送记录明细新增请求参数
 *
 * @author 顼阳
 * @date 2021/9/19 8:14 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceRecordDetailAddReqDto", description = "赠送记录明细新增请求参数")
public class BalanceRecordDetailAddReqDto {

  @ApiModelProperty(value = "客户id")
  @NotNull(message = "不能为空")
  private Long customerId;

  @ApiModelProperty(value = "订单号")
  @NotNull(message = "不能为空")
  private String orderNo;

  @ApiModelProperty(value = "商品名称")
  @NotNull(message = "不能为空")
  private String itemName;

  @ApiModelProperty(value = "商品编码")
  @NotNull(message = "不能为空")
  private String itemCode;

  @ApiModelProperty(value = "sku编码")
  @NotNull(message = "不能为空")
  private String skuCode;

  @ApiModelProperty(value = "规格值")
  private String specValue;

  @ApiModelProperty(value = "产品数量")
  private Integer productCount;

  @ApiModelProperty(value = "赠送额度(元)")
  private BigDecimal giftAmount;

  @ApiModelProperty(value = "产品折扣后金额")
  private BigDecimal productRebateAmount;

  @ApiModelProperty(value = "产品金额")
  private BigDecimal productAmount;

  @ApiModelProperty(value = "满减/满折活动立减/折扣金额(元)")
  private BigDecimal discountAmount;

  @ApiModelProperty(value = "满赠活动产品金额(元)")
  private BigDecimal discountProductAmount;

  @ApiModelProperty(value = "折扣账户抵扣金额(元)")
  private BigDecimal rabateAccountProductAmount;

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  public String getItemCode() {
    return itemCode;
  }

  public void setItemCode(String itemCode) {
    this.itemCode = itemCode;
  }

  public String getSkuCode() {
    return skuCode;
  }

  public void setSkuCode(String skuCode) {
    this.skuCode = skuCode;
  }

  public String getSpecValue() {
    return specValue;
  }

  public void setSpecValue(String specValue) {
    this.specValue = specValue;
  }

  public Integer getProductCount() {
    return productCount;
  }

  public void setProductCount(Integer productCount) {
    this.productCount = productCount;
  }

  public BigDecimal getGiftAmount() {
    return giftAmount;
  }

  public void setGiftAmount(BigDecimal giftAmount) {
    this.giftAmount = giftAmount;
  }

  public BigDecimal getProductRebateAmount() {
    return productRebateAmount;
  }

  public void setProductRebateAmount(BigDecimal productRebateAmount) {
    this.productRebateAmount = productRebateAmount;
  }

  public BigDecimal getProductAmount() {
    return productAmount;
  }

  public void setProductAmount(BigDecimal productAmount) {
    this.productAmount = productAmount;
  }

  public BigDecimal getDiscountAmount() {
    return discountAmount;
  }

  public void setDiscountAmount(BigDecimal discountAmount) {
    this.discountAmount = discountAmount;
  }

  public BigDecimal getDiscountProductAmount() {
    return discountProductAmount;
  }

  public void setDiscountProductAmount(BigDecimal discountProductAmount) {
    this.discountProductAmount = discountProductAmount;
  }

  public BigDecimal getRabateAccountProductAmount() {
    return rabateAccountProductAmount;
  }

  public void setRabateAccountProductAmount(BigDecimal rabateAccountProductAmount) {
    this.rabateAccountProductAmount = rabateAccountProductAmount;
  }
}
