/*
 * @(#)BalanceRecordQueryReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Title:BalanceRecordQueryReqDto
 *
 * <p>Description:
 *
 * @author 顼阳
 * @date 2021/9/19 8:20 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceRecordAddReqDto", description = "赠送记录明细列表查询请求参数")
public class BalanceRecordDetailQueryReqDto {

  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "订单号")
  private String orderNo;

  @ApiModelProperty(value = "组织id")
  private Long organizationId;

  @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
  private int pageSize = 10;

  @ApiModelProperty(name = "pageNum", value = "页码，选填")
  private int pageNum = 1;

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  public int getPageSize() {
    return pageSize;
  }

  public void setPageSize(int pageSize) {
    this.pageSize = pageSize;
  }

  public int getPageNum() {
    return pageNum;
  }

  public void setPageNum(int pageNum) {
    this.pageNum = pageNum;
  }
}
