/*
 * @(#)BalanceRecordQueryReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.AmountTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.GiftTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * Title:BalanceRecordQueryReqDto
 *
 * <p>Description:
 *
 * @author 顼阳
 * @date 2021/9/19 8:20 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceRecordAddReqDto", description = "赠品记录列表查询请求参数")
public class BalanceRecordQueryReqDto {

  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "订单号")
  private String orderNo;

  @ApiModelProperty(value = "赠送类型 AMOUNT_GIVE:下单产品金额比例赠送, SUM_GIVE:按下单产品数量赠送")
  private GiftTypeEnum giftTypeEnum;

  @ApiModelProperty(value = "金额类型 PRODUCT_AMOUNT:产品金额, SCALE_AMOUNT:产品折让后金额")
  private AmountTypeEnum amountTypeEnum;

  @ApiModelProperty(value = "赠送时间开始")
  private Date giftTimeStart;

  @ApiModelProperty(value = "赠送时间结束")
  private Date giftTimeEnd;

  @ApiModelProperty(value = "组织id")
  private Long organizationId;

  @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
  private int pageSize = 10;

  @ApiModelProperty(name = "pageNum", value = "页码，选填")
  private int pageNum = 1;

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  public GiftTypeEnum getGiftTypeEnum() {
    return giftTypeEnum;
  }

  public void setGiftTypeEnum(GiftTypeEnum giftTypeEnum) {
    this.giftTypeEnum = giftTypeEnum;
  }

  public AmountTypeEnum getAmountTypeEnum() {
    return amountTypeEnum;
  }

  public void setAmountTypeEnum(AmountTypeEnum amountTypeEnum) {
    this.amountTypeEnum = amountTypeEnum;
  }

  public Date getGiftTimeStart() {
    return giftTimeStart;
  }

  public void setGiftTimeStart(Date giftTimeStart) {
    this.giftTimeStart = giftTimeStart;
  }

  public Date getGiftTimeEnd() {
    return giftTimeEnd;
  }

  public void setGiftTimeEnd(Date giftTimeEnd) {
    this.giftTimeEnd = giftTimeEnd;
  }

  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  public int getPageSize() {
    return pageSize;
  }

  public void setPageSize(int pageSize) {
    this.pageSize = pageSize;
  }

  public int getPageNum() {
    return pageNum;
  }

  public void setPageNum(int pageNum) {
    this.pageNum = pageNum;
  }
}
