/*
 * @(#)BalanceRelModifyReqDto.java 1.0 2021年09月28日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * Title:BalanceRelModifyReqDto
 *
 * <p>Description: 免费赠品额度相关修改
 *
 * @author 顼阳
 * @date 2021/9/28 10:29 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceRelModifyReqDto", description = "提交订单对免费赠品额度的操作")
public class BalanceRelModifyReqDto {

  @ApiModelProperty(value = "更新余额账户")
  private GiftBalanceModifyReqDto giftBalanceModifyReqDto;

  @ApiModelProperty(value = "新增账户流水")
  private List<BalanceStatementAddReqDto> balanceStatementAddReqDtoList;

  @ApiModelProperty(value = "赠送记录")
  private List<BalanceRecordAddReqDto> balanceRecordAddReqDtoList;

  @ApiModelProperty(value = "冻结额度新增")
  private BalanceFreezeAddReqDto balanceFreezeAddReqDto;

  @ApiModelProperty(value = "冻结额度解冻")
  private BalanceFreezeModifyReqDto balanceFreezeModifyReqDto;

  public GiftBalanceModifyReqDto getGiftBalanceModifyReqDto() {
    return giftBalanceModifyReqDto;
  }

  public void setGiftBalanceModifyReqDto(GiftBalanceModifyReqDto giftBalanceModifyReqDto) {
    this.giftBalanceModifyReqDto = giftBalanceModifyReqDto;
  }

  public List<BalanceStatementAddReqDto> getBalanceStatementAddReqDtoList() {
    return balanceStatementAddReqDtoList;
  }

  public void setBalanceStatementAddReqDtoList(
      List<BalanceStatementAddReqDto> balanceStatementAddReqDtoList) {
    this.balanceStatementAddReqDtoList = balanceStatementAddReqDtoList;
  }

  public List<BalanceRecordAddReqDto> getBalanceRecordAddReqDtoList() {
    return balanceRecordAddReqDtoList;
  }

  public void setBalanceRecordAddReqDtoList(
      List<BalanceRecordAddReqDto> balanceRecordAddReqDtoList) {
    this.balanceRecordAddReqDtoList = balanceRecordAddReqDtoList;
  }

  public BalanceFreezeAddReqDto getBalanceFreezeAddReqDto() {
    return balanceFreezeAddReqDto;
  }

  public void setBalanceFreezeAddReqDto(BalanceFreezeAddReqDto balanceFreezeAddReqDto) {
    this.balanceFreezeAddReqDto = balanceFreezeAddReqDto;
  }

  public BalanceFreezeModifyReqDto getBalanceFreezeModifyReqDto() {
    return balanceFreezeModifyReqDto;
  }

  public void setBalanceFreezeModifyReqDto(BalanceFreezeModifyReqDto balanceFreezeModifyReqDto) {
    this.balanceFreezeModifyReqDto = balanceFreezeModifyReqDto;
  }
}
