/*
 * @(#)BalanceStatementAddReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.IncomeExpenditureEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Title:BalanceStatementAddReqDto
 *
 * <p>Description: 账户流水新增请求参数
 *
 * @author 顼阳
 * @date 2021/9/19 10:31 上午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceStatementAddReqDto", description = "账户流水新增请求参数")
public class BalanceStatementAddReqDto implements Serializable {

  @ApiModelProperty(value = "客户id")
  @NotNull(message = "不能为空")
  private Long customerId;

  @ApiModelProperty(value = "交易时间")
  private Date tradeTime;

  @ApiModelProperty(value = "交易类型 ORDER_REBATE:下单赠送、ORDER_DEDUCT:订单抵扣、ORDER_RETUNN:订单退回、RETURN_DEDUCT:退货扣减、QUOTA_ISSUANCE:预支额度发放、QUOTA_RETURN:预支额度归还")
  @NotNull(message = "不能为空")
  private TradeTypeEnum tradeTypeEnum;

  @ApiModelProperty(value = "交易金额")
  private BigDecimal tradeAmount;

  @ApiModelProperty(value = "收支类型 INCOME:收入, EXPENDITURE:支出 ")
  @NotNull(message = "不能为空")
  private IncomeExpenditureEnum incomeExpenditureEnum;

  @ApiModelProperty(value = "剩余余额")
  private BigDecimal balance;

  @ApiModelProperty(value = "关联单号")
  @NotNull(message = "不能为空")
  private String businessNo;

  @ApiModelProperty(value = "组织id")
  private Long organizationId;

  @ApiModelProperty(value = "租户id")
  private Long tenantId;

  @ApiModelProperty(value = "实例id")
  protected Long instanceId;

  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  public Long getInstanceId() {
    return instanceId;
  }

  public void setInstanceId(Long instanceId) {
    this.instanceId = instanceId;
  }

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public Date getTradeTime() {
    return tradeTime;
  }

  public void setTradeTime(Date tradeTime) {
    this.tradeTime = tradeTime;
  }

  public TradeTypeEnum getTradeTypeEnum() {
    return tradeTypeEnum;
  }

  public void setTradeTypeEnum(TradeTypeEnum tradeTypeEnum) {
    this.tradeTypeEnum = tradeTypeEnum;
  }

  public BigDecimal getTradeAmount() {
    return tradeAmount;
  }

  public void setTradeAmount(BigDecimal tradeAmount) {
    this.tradeAmount = tradeAmount;
  }

  public IncomeExpenditureEnum getIncomeExpenditureEnum() {
    return incomeExpenditureEnum;
  }

  public void setIncomeExpenditureEnum(IncomeExpenditureEnum incomeExpenditureEnum) {
    this.incomeExpenditureEnum = incomeExpenditureEnum;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }

  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }
}
