/*
 * @(#)BalanceStatementQueryReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.IncomeExpenditureEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 余额账号列表查询对象
 *
 * @author 即墨 Date 2021-09-01
 */
public class BalanceStatementQueryReqDto extends RequestDto {

  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "交易单号")
  private String tradeNo;

  @ApiModelProperty(value = "交易类型 ORDER_REBATE:下单赠送、ORDER_DEDUCT:订单抵扣、ORDER_RETUNN:订单退回、RETURN_DEDUCT:退货扣减、QUOTA_ISSUANCE:预支额度发放、QUOTA_RETURN:预支额度归还、GIVE_RETURN:赠送退回")
  @NotNull(message = "不能为空")
  private TradeTypeEnum tradeTypeEnum;

  @ApiModelProperty(value = "收支类型 INCOME:收入, EXPENDITURE:支出 ")
  @NotNull(message = "不能为空")
  private IncomeExpenditureEnum incomeExpenditureEnum;

  @ApiModelProperty(value = "业务单号")
  private String businessNo;

  @ApiModelProperty(value = "组织id")
  private Long organizationId;

  @ApiModelProperty(value = "冻结开始时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date tradeTimeStart;

  @ApiModelProperty(value = "冻结结束时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date tradeTimeEnd;

  @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
  private int pageSize = 10;

  @ApiModelProperty(name = "pageNum", value = "页码，选填")
  private int pageNum = 1;

  @ApiModelProperty(name = "type", value = "区分大B端 type = 0、小B端查询 type = 1")
  private int type = 0;

  @ApiModelProperty(value = "商家id")
  private String merchantId;

  @ApiModelProperty(value = "商家id 列表")
  private String merchantIdList;

  @ApiModelProperty(value = "客户ids")
  private String customerIds;

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getTradeNo() {
    return tradeNo;
  }

  public void setTradeNo(String tradeNo) {
    this.tradeNo = tradeNo;
  }

  public TradeTypeEnum getTradeTypeEnum() {
    return tradeTypeEnum;
  }

  public void setTradeTypeEnum(TradeTypeEnum tradeTypeEnum) {
    this.tradeTypeEnum = tradeTypeEnum;
  }

  public IncomeExpenditureEnum getIncomeExpenditureEnum() {
    return incomeExpenditureEnum;
  }

  public void setIncomeExpenditureEnum(IncomeExpenditureEnum incomeExpenditureEnum) {
    this.incomeExpenditureEnum = incomeExpenditureEnum;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }

  public Date getTradeTimeStart() {
    return tradeTimeStart;
  }

  public void setTradeTimeStart(Date tradeTimeStart) {
    this.tradeTimeStart = tradeTimeStart;
  }

  public Date getTradeTimeEnd() {
    return tradeTimeEnd;
  }

  public void setTradeTimeEnd(Date tradeTimeEnd) {
    this.tradeTimeEnd = tradeTimeEnd;
  }

  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  public int getPageSize() {
    return pageSize;
  }

  public void setPageSize(int pageSize) {
    this.pageSize = pageSize;
  }

  public int getPageNum() {
    return pageNum;
  }

  public void setPageNum(int pageNum) {
    this.pageNum = pageNum;
  }

  public int getType() {
    return type;
  }

  public void setType(int type) {
    this.type = type;
  }

  public String getMerchantId() {
    return merchantId;
  }

  public void setMerchantId(String merchantId) {
    this.merchantId = merchantId;
  }

  public String getMerchantIdList() {
    return merchantIdList;
  }

  public void setMerchantIdList(String merchantIdList) {
    this.merchantIdList = merchantIdList;
  }

  public String getCustomerIds() {
    return customerIds;
  }

  public void setCustomerIds(String customerIds) {
    this.customerIds = customerIds;
  }
}
