/*
 * @(#)GiftBalanceModifyReqDto.java 1.0 2021年09月23日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Title:GiftBalanceModifyReqDto
 *
 * <p>Description:
 *
 * @author 顼阳
 * @date 2021/9/23 4:13 下午
 * @since 0.1.0
 */
public class GiftBalanceModifyReqDto implements Serializable {

  @ApiModelProperty(value = "客户id")
  @NotNull(message = "不能为空")
  private Long customerId;

  @ApiModelProperty(value = "组织id")
  private Long organizationId;

  @ApiModelProperty(value = "赠品余额")
  private BigDecimal balance = BigDecimal.ZERO;

  @ApiModelProperty(value = "冻结额度(元)")
  private BigDecimal freezeBalance = BigDecimal.ZERO;

  @ApiModelProperty(value = "可用额度(元)")
  private BigDecimal usableBalance = BigDecimal.ZERO;

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public BigDecimal getFreezeBalance() {
    return freezeBalance;
  }

  public void setFreezeBalance(BigDecimal freezeBalance) {
    this.freezeBalance = freezeBalance;
  }

  public BigDecimal getUsableBalance() {
    return usableBalance;
  }

  public void setUsableBalance(BigDecimal usableBalance) {
    this.usableBalance = usableBalance;
  }

  @Override
  public String toString() {
    return new StringBuffer("GiftBalanceModifyReqDto{").append(
            "customerId=").append( customerId).append(
            ", organizationId=").append( organizationId).append(
            ", balance=").append( balance).append(
            ", freezeBalance=").append( freezeBalance).append(
            ", usableBalance=").append( usableBalance).append(
            '}').toString();
  }
}
