package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author 即墨
 * Date 2021-09-03
 */
public class GiftBalanceReturnReqDto {

    /**
     * 用户id/customerId
     */
    @ApiModelProperty(value = "用户id/customerId",required = true)
    @NotNull(message = "不能为空")
    private Long userId;
    /**
     * 退款金额
     */
    @ApiModelProperty(value = "returnAmount",required = true)
    @NotNull(message = "不能为空")
    private BigDecimal returnAmount=BigDecimal.ZERO;

    /**
     * 订单号
     */
    @ApiModelProperty(value = "orderNo",required = true)
    @NotNull(message = "不能为空")
    private String orderNo;
    /**
     * 退款单
     */
    @ApiModelProperty(value = "refundNo")
    private String refundNo;
    /**
     * 退款类型
     */
    @ApiModelProperty(value = "退款类型 退款订单:RETURN_ORDER 取消订单:CANCEL_ORDER",required = true)
    @NotNull(message = "不能为空")
    private String changeType;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public BigDecimal getReturnAmount() {
        return returnAmount;
    }

    public void setReturnAmount(BigDecimal returnAmount) {
        this.returnAmount = returnAmount;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRefundNo() {
        return refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
}
