/*
 * @(#)GiftBalanceSettingReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GivePriceTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiveTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.SwitchEnum;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 余额账号配置
 *
 * @author 即墨 Date 2021-09-01
 */
public class GiftBalanceSettingReqDto {

  @ApiModelProperty(value = "客户id")
  @NotNull(message = "不能为空")
  private Long id;

  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "免费赠送开关: ON 开 、 OFF 关")
  private SwitchEnum giveFlagEnum;

  @ApiModelProperty(value = "赠送类型: AMOUNT_OF_MONEY  按下单金额比例赠送 、 PROPORTION  按下单数量比例赠送")
  private GiveTypeEnum giveTypeEnum;

  @ApiModelProperty(value = "赠送金额类型: ORIGINAL_PRICE 产品金额 、 DISCOUNT_PRICE  产品折让后金额")
  private GivePriceTypeEnum givePriceTypeEnum;

  @ApiModelProperty(value = "赠送比例")
  private BigDecimal giveProportion;

  @ApiModelProperty(value = "换算数量")
  private BigDecimal quantityScaleSum;

  @ApiModelProperty(value = "换算金额")
  private BigDecimal quantityScaleAmount;

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public SwitchEnum getGiveFlagEnum() {
    return giveFlagEnum;
  }

  public void setGiveFlagEnum(SwitchEnum giveFlagEnum) {
    this.giveFlagEnum = giveFlagEnum;
  }

  public GiveTypeEnum getGiveTypeEnum() {
    return giveTypeEnum;
  }

  public void setGiveTypeEnum(GiveTypeEnum giveTypeEnum) {
    this.giveTypeEnum = giveTypeEnum;
  }

  public GivePriceTypeEnum getGivePriceTypeEnum() {
    return givePriceTypeEnum;
  }

  public void setGivePriceTypeEnum(GivePriceTypeEnum givePriceTypeEnum) {
    this.givePriceTypeEnum = givePriceTypeEnum;
  }

  public BigDecimal getGiveProportion() {
    return giveProportion;
  }

  public void setGiveProportion(BigDecimal giveProportion) {
    this.giveProportion = giveProportion;
  }

  public BigDecimal getQuantityScaleSum() {
    return quantityScaleSum;
  }

  public void setQuantityScaleSum(BigDecimal quantityScaleSum) {
    this.quantityScaleSum = quantityScaleSum;
  }

  public BigDecimal getQuantityScaleAmount() {
    return quantityScaleAmount;
  }

  public void setQuantityScaleAmount(BigDecimal quantityScaleAmount) {
    this.quantityScaleAmount = quantityScaleAmount;
  }

  @Override
  public String toString() {
    return new StringBuffer("GiftBalanceSettingReqDto{").append(
            "id=").append( id).append(
            ", customerId=").append( customerId).append(
            ", customerName='").append( customerName).append( '\'').append(
            ", customerCode='").append( customerCode).append( '\'').append(
            ", giveFlagEnum=").append( giveFlagEnum).append(
            ", giveTypeEnum=").append( giveTypeEnum).append(
            ", givePriceTypeEnum=").append( givePriceTypeEnum).append(
            ", giveProportion=").append( giveProportion).append(
            ", quantityScaleSum=").append( quantityScaleSum).append(
            ", quantityScaleAmount=").append( quantityScaleAmount).append(
            '}').toString();
  }
}
