/*
 * @(#)GiftConfigBaseReqDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftConfigTypeEnum;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/** @author 即墨 Date 2021-08-31 */
public class GiftConfigBaseReqDto {

  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "免费赠品额度抵扣方式 PART_DEDUCT:部分抵扣（可抵扣赠品售价的部分金额）, ALL_DEDUCT：全抵扣（赠品售价多少必须抵扣多少）")
  @NotNull(message = "不能为空")
  private GiftConfigTypeEnum configTypeEnum;

  @ApiModelProperty(value = "产品折让后金额")
  private List<String> rebateRangeList;

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public GiftConfigTypeEnum getConfigTypeEnum() {
    return configTypeEnum;
  }

  public void setConfigTypeEnum(GiftConfigTypeEnum configTypeEnum) {
    this.configTypeEnum = configTypeEnum;
  }

  public List<String> getRebateRangeList() {
    return rebateRangeList;
  }

  public void setRebateRangeList(List<String> rebateRangeList) {
    this.rebateRangeList = rebateRangeList;
  }
}
