/*
 * @(#)ItemSkuListQueryReqDto.java 1.0 2021年09月28日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 订单请求Dto
 *
 * @author xuhuaqiang
 * @since 1.0.0
 */
@ApiModel(value = "ItemSkuListQueryReqDto", description = "商品Sku请求Dto")
public class ItemSkuListQueryReqDto {

    @ApiModelProperty(name = "dirId", value = "前台目录id")
    private Long dirId;

    @ApiModelProperty(name = "backDirId", value = "后台目录id")
    private Long backDirId;

    /**
     * 商品搜索关键词
     */
    @ApiModelProperty(name = "keyword", value = "商品搜索关键词(名称/编码)")
    private String keyword;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     * 在商品id集合内查询
     */
    @ApiModelProperty(name = "outSkuIds", value = "在商品Sku的id集合外查询")
    private List<Long> outSkuIds;

    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购 2 积分商品 3 赠品商品 默认0")
    private Integer busType;

    /**
     * 客户ID
     */
    @ApiModelProperty(name = "customerId", value = "客户ID")
    private Long customerId;


    @ApiModelProperty("0 未排除   1 已排除  3 全部")
    private Integer giftExclude;

    @ApiModelProperty(name = "itemCode", value = " 商品编码  ", allowEmptyValue = true)
    private String itemCode;
    @ApiModelProperty(name = "itemCodes", value = "商品编码集合")
    private List<String> itemCodes;
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "skuCode", value = "规格编号")
    private String skuCode;

    @ApiModelProperty(name = "brandId", value = "品牌id")
    private String brandId;

    @ApiModelProperty(name = "customerIds", value = "客户ID集合")
    private List<Long> customerIds;


    private Integer pageNum = 1;

    private Integer pageSize = 10;

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getBackDirId() {
        return backDirId;
    }

    public void setBackDirId(Long backDirId) {
        this.backDirId = backDirId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public List<Long> getOutSkuIds() {
        return outSkuIds;
    }

    public void setOutSkuIds(List<Long> outSkuIds) {
        this.outSkuIds = outSkuIds;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Integer getGiftExclude() {
        return giftExclude;
    }

    public void setGiftExclude(Integer giftExclude) {
        this.giftExclude = giftExclude;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public List<Long> getCustomerIds() {
        return customerIds;
    }

    public void setCustomerIds(List<Long> customerIds) {
        this.customerIds = customerIds;
    }

    public List<String> getItemCodes() {
        return itemCodes;
    }

    public void setItemCodes(List<String> itemCodes) {
        this.itemCodes = itemCodes;
    }
}
