/*
 * @(#)BalanceAdvanceListRespDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.AdvanceStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.SendBackEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Title:BalanceAdvanceListRespDto
 *
 * <p>Description:
 *
 * @author 顼阳
 * @date 2021/9/19 8:21 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceAdvanceListRespDto", description = "预支额度列表查询请求参数")
public class BalanceAdvanceListRespDto {

  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "预支时间")
  private Date advanceTime;

  @ApiModelProperty(value = "预支单号")
  private String advanceNo;

  @ApiModelProperty(value = "预支额度(元)")
  private BigDecimal advanceAmount;

  @ApiModelProperty(value = "额度发放时间(元) ")
  private Date advanceGrantTime;

  @ApiModelProperty(value = "是否需要归还")
  private String sendBack;

  @ApiModelProperty(value = "是否需要归还")
  private String sendBackName;

  @ApiModelProperty(value = "额度归还时间(元)")
  private Date advanceSendBackTime;

  @ApiModelProperty(value = "状态")
  private String status;

  @ApiModelProperty(value = "状态")
  private String statusName;

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public Date getAdvanceTime() {
    return advanceTime;
  }

  public void setAdvanceTime(Date advanceTime) {
    this.advanceTime = advanceTime;
  }

  public String getAdvanceNo() {
    return advanceNo;
  }

  public void setAdvanceNo(String advanceNo) {
    this.advanceNo = advanceNo;
  }

  public BigDecimal getAdvanceAmount() {
    return advanceAmount;
  }

  public void setAdvanceAmount(BigDecimal advanceAmount) {
    this.advanceAmount = advanceAmount;
  }

  public Date getAdvanceGrantTime() {
    return advanceGrantTime;
  }

  public void setAdvanceGrantTime(Date advanceGrantTime) {
    this.advanceGrantTime = advanceGrantTime;
  }

  public String getSendBack() {
    return sendBack;
  }

  public void setSendBack(String sendBack) {
    this.sendBack = sendBack;
  }

  public Date getAdvanceSendBackTime() {
    return advanceSendBackTime;
  }

  public void setAdvanceSendBackTime(Date advanceSendBackTime) {
    this.advanceSendBackTime = advanceSendBackTime;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getSendBackName() {
    return SendBackEnum.toName(this.sendBack);
  }

  public void setSendBackName(String sendBackName) {
    this.sendBackName = sendBackName;
  }

  public String getStatusName() {
    return AdvanceStatusEnum.toName(this.status);
  }

  public void setStatusName(String statusName) {
    this.statusName = statusName;
  }
}
