/*
 * @(#)BalanceFreezeListRespDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.FreezeStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.FreezeTypeEnum;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Title:BalanceFreezeListRespDto
 *
 * <p>Description: 冻结额度
 *
 * @author 顼阳
 * @date 2021/9/19 8:21 下午
 * @since 0.1.0
 */
public class BalanceFreezeListRespDto {

  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "冻结时间")
  private Date freezeTime;

  @ApiModelProperty(value = "冻结额度(元)")
  private BigDecimal freezeAmount;

  @ApiModelProperty(value = "冻结类型")
  private String freezeType;

  @ApiModelProperty(value = "冻结类型")
  private String freezeTypeName;

  @ApiModelProperty(value = "业务单号")
  private String businessNo;

  @ApiModelProperty(value = "解冻时间")
  private Date unFreezeTime;

  @ApiModelProperty(value = "状态")
  private String status;

  @ApiModelProperty(value = "状态名称")
  private String statusName;

  @ApiModelProperty(value = "冻结原因")
  private String reason;

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public Date getFreezeTime() {
    return freezeTime;
  }

  public void setFreezeTime(Date freezeTime) {
    this.freezeTime = freezeTime;
  }

  public BigDecimal getFreezeAmount() {
    return freezeAmount;
  }

  public void setFreezeAmount(BigDecimal freezeAmount) {
    this.freezeAmount = freezeAmount;
  }

  public String getFreezeType() {
    return freezeType;
  }

  public void setFreezeType(String freezeType) {
    this.freezeType = freezeType;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }

  public Date getUnFreezeTime() {
    return unFreezeTime;
  }

  public void setUnFreezeTime(Date unFreezeTime) {
    this.unFreezeTime = unFreezeTime;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public String getFreezeTypeName() {
    return FreezeTypeEnum.toName(this.freezeType);
  }

  public void setFreezeTypeName(String freezeTypeName) {
    this.freezeTypeName = freezeTypeName;
  }

  public String getStatusName() {
    return FreezeStatusEnum.toName(status);
  }

  public void setStatusName(String statusName) {
    this.statusName = statusName;
  }
}
