/*
 * @(#)BalanceListRespDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GivePriceTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiveTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.SwitchEnum;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 余额账户列表
 *
 * @author 即墨 Date 2021-09-01
 */
public class BalanceListRespDto {

  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "剩余额度(元)")
  private BigDecimal balance;

  @ApiModelProperty(value = "冻结额度(元)")
  private BigDecimal freezeBalance;

  @ApiModelProperty(value = "可用额度(元)")
  private BigDecimal usableBalance;

  @ApiModelProperty(value = "免费赠送")
  private String giveFlag;

  @ApiModelProperty(value = "赠送类型")
  private String giveType;

  @ApiModelProperty(value = "赠送类型 - 显示名称")
  private String giveTypeName;

  @ApiModelProperty(value = "预支额度")
  private BigDecimal overdraft;

  @ApiModelProperty(value = "预支额度开关")
  private String overdraftFlag;

  @ApiModelProperty(value = "预支额度开关 - 显示名称")
  private String overdraftFlagName;

  @ApiModelProperty(value = "免费赠送开关 - 显示名称")
  private String giveFlagName;

  @ApiModelProperty(value = "赠送比例")
  private BigDecimal giveProportion;

  @ApiModelProperty(value = "金额类型")
  private String givePriceType;

  @ApiModelProperty(value = "金额类型 - 显示名称")
  private String givePriceTypeName;

  @ApiModelProperty(value = "换算数量")
  private BigDecimal quantityScaleSum;

  @ApiModelProperty(value = "换算金额")
  private BigDecimal quantityScaleAmount;

  @ApiModelProperty(value = "租户组织id")
  private Long organizationId;

  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public BigDecimal getFreezeBalance() {
    return freezeBalance;
  }

  public void setFreezeBalance(BigDecimal freezeBalance) {
    this.freezeBalance = freezeBalance;
  }

  public BigDecimal getUsableBalance() {
    return usableBalance;
  }

  public void setUsableBalance(BigDecimal usableBalance) {
    this.usableBalance = usableBalance;
  }

  public String getGiveFlag() {
    return giveFlag;
  }

  public void setGiveFlag(String giveFlag) {
    this.giveFlag = giveFlag;
  }

  public String getGiveType() {
    return giveType;
  }

  public void setGiveType(String giveType) {
    this.giveType = giveType;
  }

  public String getGiveTypeName() {
    return GiveTypeEnum.toName(this.giveType);
  }

  public void setGiveTypeName(String giveTypeName) {
    this.giveTypeName = giveTypeName;
  }

  public BigDecimal getOverdraft() {
    return overdraft;
  }

  public void setOverdraft(BigDecimal overdraft) {
    this.overdraft = overdraft;
  }

  public String getOverdraftFlag() {
    return overdraftFlag;
  }

  public void setOverdraftFlag(String overdraftFlag) {
    this.overdraftFlag = overdraftFlag;
  }

  public String getOverdraftFlagName() {
    return overdraftFlagName;
  }

  public void setOverdraftFlagName(String overdraftFlagName) {
    this.overdraftFlagName = overdraftFlagName;
  }

  public String getGiveFlagName() {
    return SwitchEnum.toName(giveFlag);
  }

  public void setGiveFlagName(String giveFlagName) {
    this.giveFlagName = giveFlagName;
  }

  public BigDecimal getGiveProportion() {
    return giveProportion;
  }

  public void setGiveProportion(BigDecimal giveProportion) {
    this.giveProportion = giveProportion;
  }

  public String getGivePriceType() {
    return givePriceType;
  }

  public void setGivePriceType(String givePriceType) {
    this.givePriceType = givePriceType;
  }

  public String getGivePriceTypeName() {
    return GivePriceTypeEnum.toName(this.givePriceType);
  }

  public void setGivePriceTypeName(String givePriceTypeName) {
    this.givePriceTypeName = givePriceTypeName;
  }

  public BigDecimal getQuantityScaleSum() {
    return quantityScaleSum;
  }

  public void setQuantityScaleSum(BigDecimal quantityScaleSum) {
    this.quantityScaleSum = quantityScaleSum;
  }

  public BigDecimal getQuantityScaleAmount() {
    return quantityScaleAmount;
  }

  public void setQuantityScaleAmount(BigDecimal quantityScaleAmount) {
    this.quantityScaleAmount = quantityScaleAmount;
  }

  @Override
  public String toString() {
    return "BalanceListRespDto{" +
            "id=" + id +
            ", customerId=" + customerId +
            ", customerName='" + customerName + '\'' +
            ", customerCode='" + customerCode + '\'' +
            ", balance=" + balance +
            ", freezeBalance=" + freezeBalance +
            ", usableBalance=" + usableBalance +
            ", giveFlag='" + giveFlag + '\'' +
            ", giveType='" + giveType + '\'' +
            ", giveTypeName='" + giveTypeName + '\'' +
            ", overdraft=" + overdraft +
            ", overdraftFlag='" + overdraftFlag + '\'' +
            ", overdraftFlagName='" + overdraftFlagName + '\'' +
            ", giveFlagName='" + giveFlagName + '\'' +
            ", giveProportion=" + giveProportion +
            ", givePriceType='" + givePriceType + '\'' +
            ", givePriceTypeName='" + givePriceTypeName + '\'' +
            ", quantityScaleSum=" + quantityScaleSum +
            ", quantityScaleAmount=" + quantityScaleAmount +
            '}';
  }
}
