/*
 * @(#)BalanceRecordListRespDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance;

import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Title:BalanceRecordListRespDto
 *
 * <p>Description:赠送记录明细列表
 *
 * @author 顼阳
 * @date 2021/9/19 8:21 下午
 * @since 0.1.0
 */
public class BalanceRecordDetailListRespDto {

  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "商品名称")
  private String itemName;

  @ApiModelProperty(value = "商品编码")
  private String itemCode;

  @ApiModelProperty(value = "sku编码")
  private String skuCode;

  @ApiModelProperty(value = "规格值")
  private String specValue;

  @ApiModelProperty(value = "产品数量")
  private String productCount;

  @ApiModelProperty(value = "赠送额度(元)")
  private BigDecimal giftAmount;

  @ApiModelProperty(value = "产品折扣后金额")
  private String productRebateAmount;

  @ApiModelProperty(value = "产品金额")
  private String productAmount;

  @ApiModelProperty(value = "满减/满折活动立减/折扣金额(元)")
  private BigDecimal discountAmount;

  @ApiModelProperty(value = "满赠活动产品金额(元)")
  private BigDecimal discountProductAmount;

  @ApiModelProperty(value = "折扣账户抵扣金额(元)")
  private BigDecimal rabateAccountProductAmount;

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  public String getItemCode() {
    return itemCode;
  }

  public void setItemCode(String itemCode) {
    this.itemCode = itemCode;
  }

  public String getSkuCode() {
    return skuCode;
  }

  public void setSkuCode(String skuCode) {
    this.skuCode = skuCode;
  }

  public String getSpecValue() {
    return specValue;
  }

  public void setSpecValue(String specValue) {
    this.specValue = specValue;
  }

  public String getProductCount() {
    return productCount;
  }

  public void setProductCount(String productCount) {
    this.productCount = productCount;
  }

  public BigDecimal getGiftAmount() {
    return giftAmount;
  }

  public void setGiftAmount(BigDecimal giftAmount) {
    this.giftAmount = giftAmount;
  }

  public String getProductRebateAmount() {
    return productRebateAmount;
  }

  public void setProductRebateAmount(String productRebateAmount) {
    this.productRebateAmount = productRebateAmount;
  }

  public String getProductAmount() {
    return productAmount;
  }

  public void setProductAmount(String productAmount) {
    this.productAmount = productAmount;
  }

  public BigDecimal getDiscountAmount() {
    return discountAmount;
  }

  public void setDiscountAmount(BigDecimal discountAmount) {
    this.discountAmount = discountAmount;
  }

  public BigDecimal getDiscountProductAmount() {
    return discountProductAmount;
  }

  public void setDiscountProductAmount(BigDecimal discountProductAmount) {
    this.discountProductAmount = discountProductAmount;
  }

  public BigDecimal getRabateAccountProductAmount() {
    return rabateAccountProductAmount;
  }

  public void setRabateAccountProductAmount(BigDecimal rabateAccountProductAmount) {
    this.rabateAccountProductAmount = rabateAccountProductAmount;
  }
}
