/*
 * @(#)BalanceRecordListRespDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.AmountTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.GiftTypeEnum;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Title:BalanceRecordListRespDto
 *
 * <p>Description:赠送记录列表
 *
 * @author 顼阳
 * @date 2021/9/19 8:21 下午
 * @since 0.1.0
 */
public class BalanceRecordListRespDto {

  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "赠送时间")
  private Date giftTime;

  @ApiModelProperty(value = "订单号")
  private String orderNo;

  @ApiModelProperty(value = "赠送金额(元)")
  private BigDecimal giftAmount;

  @ApiModelProperty(value = "赠送类型")
  private String giftType;

  @ApiModelProperty(value = "赠送类型")
  private String giftTypeName;

  @ApiModelProperty(value = "赠送比例")
  private String giftScale;

  @ApiModelProperty(value = "金额类型")
  private String amountType;

  @ApiModelProperty(value = "金额类型")
  private String amountTypeName;

  @ApiModelProperty(value = "换算数量")
  private BigDecimal quantityScaleSum;

  @ApiModelProperty(value = "换算金额")
  private BigDecimal quantityScaleAmount;

  @ApiModelProperty(value = "产品数量")
  private String productCount;

  @ApiModelProperty(value = "产品折扣后金额")
  private BigDecimal productRebateAmount;

  @ApiModelProperty(value = "产品金额")
  private BigDecimal productAmount;

  @ApiModelProperty(value = "满减/满折活动立减/折扣金额(元)")
  private BigDecimal discountAmount;

  @ApiModelProperty(value = "满赠活动产品金额(元)")
  private BigDecimal discountProductAmount;

  @ApiModelProperty(value = "折扣账户抵扣金额(元)")
  private BigDecimal rabateAccountProductAmount;

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public Date getGiftTime() {
    return giftTime;
  }

  public void setGiftTime(Date giftTime) {
    this.giftTime = giftTime;
  }

  public String getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  public BigDecimal getGiftAmount() {
    return giftAmount;
  }

  public void setGiftAmount(BigDecimal giftAmount) {
    this.giftAmount = giftAmount;
  }

  public String getGiftType() {
    return giftType;
  }

  public void setGiftType(String giftType) {
    this.giftType = giftType;
  }

  public String getGiftScale() {
    /*BigDecimal value = giftAmount == null || productRebateAmount == null ? BigDecimal.ZERO : giftAmount.divide(productRebateAmount, 2, BigDecimal.ROUND_HALF_UP);
    return value.toString();*/
    return giftScale;
  }

  public void setGiftScale(String giftScale) {
    this.giftScale = giftScale;
  }

  public String getAmountType() {
    return amountType;
  }

  public void setAmountType(String amountType) {
    this.amountType = amountType;
  }

  public BigDecimal getQuantityScaleSum() {
    return quantityScaleSum;
  }

  public void setQuantityScaleSum(BigDecimal quantityScaleSum) {
    this.quantityScaleSum = quantityScaleSum;
  }

  public BigDecimal getQuantityScaleAmount() {
    return quantityScaleAmount;
  }

  public void setQuantityScaleAmount(BigDecimal quantityScaleAmount) {
    this.quantityScaleAmount = quantityScaleAmount;
  }

  public String getProductCount() {
    return productCount;
  }

  public void setProductCount(String productCount) {
    this.productCount = productCount;
  }

  public BigDecimal getProductRebateAmount() {
    return productRebateAmount;
  }

  public void setProductRebateAmount(BigDecimal productRebateAmount) {
    this.productRebateAmount = productRebateAmount;
  }

  public BigDecimal getProductAmount() {
    return productAmount;
  }

  public void setProductAmount(BigDecimal productAmount) {
    this.productAmount = productAmount;
  }

  public BigDecimal getDiscountAmount() {
    return discountAmount;
  }

  public void setDiscountAmount(BigDecimal discountAmount) {
    this.discountAmount = discountAmount;
  }

  public BigDecimal getDiscountProductAmount() {
    return discountProductAmount;
  }

  public void setDiscountProductAmount(BigDecimal discountProductAmount) {
    this.discountProductAmount = discountProductAmount;
  }

  public BigDecimal getRabateAccountProductAmount() {
    return rabateAccountProductAmount;
  }

  public void setRabateAccountProductAmount(BigDecimal rabateAccountProductAmount) {
    this.rabateAccountProductAmount = rabateAccountProductAmount;
  }

  public String getGiftTypeName() {
    return GiftTypeEnum.toName(this.giftType);
  }

  public void setGiftTypeName(String giftTypeName) {
    this.giftTypeName = giftTypeName;
  }

  public String getAmountTypeName() {
    return AmountTypeEnum.toName(this.amountType);
  }

  public void setAmountTypeName(String amountTypeName) {
    this.amountTypeName = amountTypeName;
  }
}
