/*
 * @(#)BalanceStatementListRespDto.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance;

import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.IncomeExpenditureEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 余额账户列表
 *
 * @author 即墨 Date 2021-09-01
 */
public class BalanceStatementListRespDto {

  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "客户id")
  private Long customerId;

  @ApiModelProperty(value = "客户名称")
  private String customerName;

  @ApiModelProperty(value = "客户编号")
  private String customerCode;

  @ApiModelProperty(value = "交易时间")
  private Date tradeTime;

  @ApiModelProperty(value = "交易单号")
  private String tradeNo;

  @ApiModelProperty(value = "交易类型")
  private String tradeType;

  @ApiModelProperty(value = "交易类型 - 展示名称")
  private String tradeTypeName;

  @ApiModelProperty(value = "交易金额")
  private BigDecimal tradeAmount;

  @ApiModelProperty(value = "收支类型")
  private String incomeExpenditure;

  @ApiModelProperty(value = "收支类型 - 展示名称")
  private String incomeExpenditureName;

  @ApiModelProperty(value = "余额")
  private BigDecimal balance;

  @ApiModelProperty(value = "关联业务单号")
  private String businessNo;

  @ApiModelProperty(value = "组织id")
  private Long organizationId;

  @ApiModelProperty(value = "商家名称")
  private String shopName;

  @ApiModelProperty(value = "备注")
  private String remark;

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getShopName() {
    return shopName;
  }

  public void setShopName(String shopName) {
    this.shopName = shopName;
  }

  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Long getCustomerId() {
    return customerId;
  }

  public void setCustomerId(Long customerId) {
    this.customerId = customerId;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public Date getTradeTime() {
    return tradeTime;
  }

  public void setTradeTime(Date tradeTime) {
    this.tradeTime = tradeTime;
  }

  public String getTradeNo() {
    return tradeNo;
  }

  public void setTradeNo(String tradeNo) {
    this.tradeNo = tradeNo;
  }

  public String getTradeType() {
    return tradeType;
  }

  public void setTradeType(String tradeType) {
    this.tradeType = tradeType;
  }

  public String getTradeTypeName() {
    return TradeTypeEnum.toName(this.tradeType);
  }

  public void setTradeTypeName(String tradeTypeName) {
    this.tradeTypeName = tradeTypeName;
  }

  public BigDecimal getTradeAmount() {
    return tradeAmount;
  }

  public void setTradeAmount(BigDecimal tradeAmount) {
    this.tradeAmount = tradeAmount;
  }

  public String getIncomeExpenditure() {
    return incomeExpenditure;
  }

  public void setIncomeExpenditure(String incomeExpenditure) {
    this.incomeExpenditure = incomeExpenditure;
  }

  public String getIncomeExpenditureName() {
    return IncomeExpenditureEnum.toName(this.incomeExpenditure);
  }

  public void setIncomeExpenditureName(String incomeExpenditureName) {
    this.incomeExpenditureName = incomeExpenditureName;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public String getBusinessNo() {
    return businessNo;
  }

  public void setBusinessNo(String businessNo) {
    this.businessNo = businessNo;
  }
}
