/*
 * @(#)BalanceStatementListSumRespDto.java 1.0 2022年05月10日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>Title:BalanceStatementListSumRespDto</p>
 * <p>Description: 账户流水汇总</p>
 *
 * @author 顼阳
 * @date 2022/5/10 2:31 下午
 * @since 0.1.0
 */
@ApiModel(value = "BalanceStatementListSumRespDto", description = "账户流水汇总")
public class BalanceStatementListSumRespDto implements Serializable {

    private static final long serialVersionUID = -8618525001285428437L;

    @ApiModelProperty(name = "payAmountTotal", value = "支出")
    private BigDecimal payAmountTotal;
    @ApiModelProperty(name = "incomeAmountTotal", value = "收入")
    private BigDecimal incomeAmountTotal;

    public BigDecimal getPayAmountTotal() {
        return payAmountTotal;
    }

    public void setPayAmountTotal(BigDecimal payAmountTotal) {
        this.payAmountTotal = payAmountTotal;
    }

    public BigDecimal getIncomeAmountTotal() {
        return incomeAmountTotal;
    }

    public void setIncomeAmountTotal(BigDecimal incomeAmountTotal) {
        this.incomeAmountTotal = incomeAmountTotal;
    }

    @Override
    public String toString() {
        return "BalanceStatementListSumRespDto{" +
                "payAmountTotal=" + payAmountTotal +
                ", incomeAmountTotal=" + incomeAmountTotal +
                '}';
    }
}
