package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * GiftBalanceRespDto对象
 *
 * @author haoyang
 * @since 2021-09-28
 */
@ApiModel(value = "GiftBalanceRespDto", description = "GiftBalance响应对象")
public class GiftBalanceRespDto {

    /**
     * 客户id
     */
    @ApiModelProperty(value = "客户id")
    private Long customerId;
    /**
     * 组织id
     */
    @ApiModelProperty(value = "组织id")
    private Long organizationId;
    /**
     * 冻结额度
     */
    @ApiModelProperty(value = "冻结额度")
    private BigDecimal freezeBalance;
    /**
     * 可用额度
     */
    @ApiModelProperty(value = "可用额度")
    private BigDecimal usableBalance;

    @ApiModelProperty(
            name = "merchantId",
            value = "所属商家id（实际存的是所属商家对应的组织即上游组织）"
    )
    private Long merchantId;

    @ApiModelProperty(
            name = "merchantName",
            value = "所属商家名称（实际存的是所属商家对应的组织即上游组织）"
    )
    private String merchantName;

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public BigDecimal getFreezeBalance() {
        return freezeBalance;
    }

    public void setFreezeBalance(BigDecimal freezeBalance) {
        this.freezeBalance = freezeBalance;
    }

    public BigDecimal getUsableBalance() {
        return usableBalance;
    }

    public void setUsableBalance(BigDecimal usableBalance) {
        this.usableBalance = usableBalance;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }
}
