/*
 * @(#)ItemPriceExtDto.java 1.0 2021年09月28日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance;

import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
* @Description: 请求价格中心扩展 Dto
* @Author: sanqiu.qwz@dtyunxi.com
* @CreateDate: 2021/7/21 16:17
* @Version V1.0
*/
public class ItemPriceExtDto {

    @ApiModelProperty(name = "skuId", value = "商品skuId")
    private Long skuId;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "retailPrice", value = "商品零售价")
    private BigDecimal retailPrice;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "是否存在阶梯价格")
    private boolean hasLadderPrice;

    @ApiModelProperty(value = "商品阶梯价格")
    private List<LadderPrice> ladderPrices = new ArrayList<>();

    /**
     * 是否存在折扣价格
     */
    @ApiModelProperty(value = "是否存在折扣价格")
    private boolean hasDiscountPrice;

    /**
     * 计算折扣后的价格
     */
    @ApiModelProperty(value = "折扣价格")
    private BigDecimal discountPrice;

    public static class LadderPrice {
        /**
         * 数量下限
         */
        private Integer lower;
        /**
         * 数量上限
         */
        private Integer upper;
        /**
         * 价格
         */
        private BigDecimal price;

        public Integer getLower() {
            return lower;
        }

        public void setLower(Integer lower) {
            this.lower = lower;
        }

        public Integer getUpper() {
            return upper;
        }

        public void setUpper(Integer upper) {
            this.upper = upper;
        }

        public BigDecimal getPrice() {
            return price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }


    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    public boolean isHasLadderPrice() {
        return hasLadderPrice;
    }

    public void setHasLadderPrice(boolean hasLadderPrice) {
        this.hasLadderPrice = hasLadderPrice;
    }

    public List<LadderPrice> getLadderPrices() {
        return ladderPrices;
    }

    public void setLadderPrices(List<LadderPrice> ladderPrices) {
        this.ladderPrices = ladderPrices;
    }

    public boolean isHasDiscountPrice() {
        return hasDiscountPrice;
    }

    public void setHasDiscountPrice(boolean hasDiscountPrice) {
        this.hasDiscountPrice = hasDiscountPrice;
    }

    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }
}
