/*
 * @(#)ItemSkuListRespDto.java 1.0 2021年09月28日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品Sku信息
 *
 * @author xuhuaqiang
 * @since 1.0.0
 */
@ApiModel(value = "ItemSkuListRespDto", description = "商品Sku信息")
public class ItemSkuListRespDto extends ItemPriceExtDto {
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "id", value = "id")
    private Long id;
    @ApiModelProperty(name = "itemCode", value = " 商品编码  ", allowEmptyValue = true)
    private String itemCode;
    @ApiModelProperty(name = "skuName", value = "属性")
    private String attr;
    @ApiModelProperty(name = "path", value = "商品图片")
    private String path;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "商品skuId")
    private Long skuId;

    @ApiModelProperty(name = "skuCode", value = "规格编号")
    private String skuCode;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "skuName", value = "规格名称")
    private String skuName;

    @ApiModelProperty(name = "itemNum", value = "购买数量")
    private Long itemNum;

    @ApiModelProperty(name = "sellPrice", value = "商品售价")
    private BigDecimal sellPrice;

    @ApiModelProperty(name = "retailPrice", value = "商品零售价")
    private BigDecimal retailPrice;

    @ApiModelProperty(name = "unit", value = "单位")
    private String unit;

    @ApiModelProperty(name = "unitName", value = "单位名称")
    private String unitName;

    @ApiModelProperty(name = "shelfType", value = "上架类型:1普通上架  2周期购上架")
    private Integer shelfType;

    @ApiModelProperty(name = "dirId", value = "后台目录id")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "后台目录名称")
    private String dirName;

    @ApiModelProperty(name = "frontDirNames", value = "前台目录名称集合")
    private List<String> frontDirNames;

    @ApiModelProperty(name = "frontDirIds", value = "前台目录id集合")
    private List<Long> frontDirIds;

    @ApiModelProperty(name = "wholesaleLimitMin", value = "起订量")
    private Long wholesaleLimitMin;

    @ApiModelProperty(name = "wholesaleLimitMax", value = "限定量")
    private Long wholesaleLimitMax;

    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;

    @ApiModelProperty(name = "brandName", value = "品牌名称")
    private String brandName;

    @ApiModelProperty("0 未排除   1 已排除")
    private Integer giftExclude;

    @ApiModelProperty(name = "subType", value = "商品子类型")
    private String subType;

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public List<String> getFrontDirNames() {
        return frontDirNames;
    }

    public void setFrontDirNames(List<String> frontDirNames) {
        this.frontDirNames = frontDirNames;
    }

    public List<Long> getFrontDirIds() {
        return frontDirIds;
    }

    public void setFrontDirIds(List<Long> frontDirIds) {
        this.frontDirIds = frontDirIds;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Long getItemNum() {
        return itemNum;
    }

    public void setItemNum(Long itemNum) {
        this.itemNum = itemNum;
    }

    public BigDecimal getSellPrice() {
        return sellPrice;
    }

    public void setSellPrice(BigDecimal sellPrice) {
        this.sellPrice = sellPrice;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Integer getShelfType() {
        return shelfType;
    }

    public void setShelfType(Integer shelfType) {
        this.shelfType = shelfType;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }



    public Long getWholesaleLimitMin() {
        return wholesaleLimitMin;
    }

    public void setWholesaleLimitMin(Long wholesaleLimitMin) {
        this.wholesaleLimitMin = wholesaleLimitMin;
    }

    public Long getWholesaleLimitMax() {
        return wholesaleLimitMax;
    }

    public void setWholesaleLimitMax(Long wholesaleLimitMax) {
        this.wholesaleLimitMax = wholesaleLimitMax;
    }

    public Integer getGiftExclude() {
        return giftExclude;
    }

    public void setGiftExclude(Integer giftExclude) {
        this.giftExclude = giftExclude;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
}
