package com.dtyunxi.yundt.cube.center.rebate.api.gift.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceAdvanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceAdvanceListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：预支额度"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftBalanceAdvanceQueryApi",
        name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
        url = "${yundt-cube-center-rebate_api:}",
        path = "/v1/gift/balance-advance"
)
public interface IGiftBalanceAdvanceQueryApi {

    @GetMapping("list")
    @ApiOperation(value = "预支额度列表", notes = "预支额度列表")
    RestResponse<PageInfo<BalanceAdvanceListRespDto>> queryPage(@ModelAttribute BalanceAdvanceQueryReqDto reqDto);


    @GetMapping("/exportGiftBalanceAdvance")
    @ApiOperation(value = "预支额度列表导出", notes = "预支额度列表导出")
    RestResponse<Object> exportGiftBalanceAdvance(@ModelAttribute BalanceAdvanceQueryReqDto reqDto);

}
