package com.dtyunxi.yundt.cube.center.rebate.api.gift.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceFreezeQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceFreezeListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：冻结额度"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftBalanceFreezeQueryApi",
        name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
        url = "${yundt-cube-center-rebate_api:}",
        path = "/v1/gift/balance-freeze"
)
public interface IGiftBalanceFreezeQueryApi {

    @GetMapping(value = "list",  produces = "application/json")
    @ApiOperation(value = "冻结额度列表", notes = "冻结额度列表")
    RestResponse<PageInfo<BalanceFreezeListRespDto>> queryPage(@ModelAttribute BalanceFreezeQueryReqDto reqDto);

}
