package com.dtyunxi.yundt.cube.center.rebate.api.gift.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceConfigReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceStatementQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceSettingQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：赠品余额"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftBalanceQueryApi",
    name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
    url = "${yundt-cube-center-rebate_api:}",
    path = "/v1/gift/balance")
public interface IGiftBalanceQueryApi {

  @GetMapping("list")
  @ApiOperation(value = "账户列表", notes = "账户列表")
  RestResponse<PageInfo<BalanceListRespDto>> queryPage(BalanceQueryReqDto reqDto);

  @GetMapping(value = "/detail", produces = "application/json")
  @ApiOperation(value = "账户配置 - 查看", notes = "账户配置 - 查看")
  RestResponse<GiftBalanceSettingRepsDto> querySetting(
      @ModelAttribute GiftBalanceSettingQueryReqDto queryReqDto);

  /**
   * 查询免费赠品账户信息
   *
   * @return 查询免费赠品账户信息
   */
  @PostMapping("/queryByCustomerId")
  @ApiOperation(value = "查询免费赠品账户信息", notes = "查询免费赠品账户信息")
  RestResponse<BalanceDetailRespDto> queryByCustomerId(@RequestBody BalanceQueryReqDto reqDto);

  /**
   * 查询账户信息、总控配置、排查商品
   *
   * @return
   */
  @PostMapping("/queryBalanceConfig")
  @ApiOperation(value = "查询账户信息、总控配置、排查商品", notes = "查询账户信息、总控配置、排查商品")
  RestResponse<BalanceConfigRespDto> queryBalanceConfig(@ModelAttribute BalanceConfigReqDto reqDto);

  /**
   * 根据id查询免费赠品管理
   *
   * @return   返利账户数据
   */
  @GetMapping("/preview")
  @ApiOperation(value = "移动端 - 免费赠品管理", notes = "移动端 - 免费赠品管理")
  RestResponse<GiftBalanceGroupRespDto> queryGiftBalanceByOrganizationId();

  /**
   * 免费赠品流水统计
   * @param reqDto
   * @return
   */
  @GetMapping("/count")
  @ApiOperation(value = "免费赠品流水统计", notes = "免费赠品流水统计")
  RestResponse<GiftBalanceCountRespDto> countGiftBalanceStatement(@SpringQueryMap BalanceStatementQueryReqDto reqDto);

  @GetMapping("/exportGiftBalance")
  @ApiOperation(value = "账户列表导出", notes = "账户列表导出")
  RestResponse<Object> exportGiftBalance(@ModelAttribute BalanceQueryReqDto reqDto);

}
