package com.dtyunxi.yundt.cube.center.rebate.api.gift.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordQueryGiftAmountReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceSettingQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceRecordDetailListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceRecordDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceRecordListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceSettingRepsDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：赠送记录"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftBalanceRecordQueryApi",
        name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
        url = "${yundt-cube-center-rebate_api:}",
        path = "/v1/gift/balance-record"
)
public interface IGiftBalanceRecordQueryApi {

    @GetMapping("list")
    @ApiOperation(value = "赠送记录列表", notes = "赠送记录列表")
    RestResponse<PageInfo<BalanceRecordListRespDto>> queryPage(@ModelAttribute BalanceRecordQueryReqDto reqDto);


    @GetMapping(value = "/detail/{id}", produces = "application/json")
    @ApiOperation(value = "赠送记录列表 - 查看明细", notes = "赠送记录列表 - 查看明细")
    RestResponse<BalanceRecordDetailRespDto> queryDetail(@Valid @PathVariable Long id);

    @PostMapping(value = "/queryDetailByOrderNos", produces = "application/json")
    @ApiOperation(value = "根据订单号集合查看明细", notes = "赠送记录列表 - 查看明细")
    RestResponse<List<BalanceRecordDetailRespDto>> queryDetailByOrderNos(@RequestBody List<String> orderNos);

    @GetMapping("detail/list")
    @ApiOperation(value = "赠送记录明细列表", notes = "赠送记录明细列表")
    RestResponse<PageInfo<BalanceRecordDetailListRespDto>> queryPageDetail(@ModelAttribute BalanceRecordDetailQueryReqDto reqDto);

    @GetMapping("/query/gift-amount")
    @ApiOperation(value = "查找订单赠送额度", notes = "查找订单赠送额度")
    RestResponse<BigDecimal> queryGitfAmount(@ModelAttribute BalanceRecordQueryGiftAmountReqDto reqDto);
}
