package com.dtyunxi.yundt.cube.center.rebate.api.gift.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceStatementQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceStatementListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceStatementListSumRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：赠品流水"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftBalanceStatementQueryApi",
        name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
        url = "${yundt-cube-center-rebate_api:}",
        path = "/v1/gift/balance-statement"
)
public interface IGiftBalanceStatementQueryApi {

    @GetMapping("list")
    @ApiOperation(value = "账户流水", notes = "账户流水")
    RestResponse<PageInfo<BalanceStatementListRespDto>> queryPage(@ModelAttribute BalanceStatementQueryReqDto reqDto);

    @PostMapping("/list")
    @ApiOperation(value = "账户流水", notes = "账户流水")
    RestResponse<PageInfo<BalanceStatementListRespDto>> queryPageOnPost(@RequestBody BalanceStatementQueryReqDto reqDto);

    @GetMapping("/exportGiftBalanceStatement")
    @ApiOperation(value = "账户流水列表导出", notes = "账户流水列表导出")
    RestResponse<Object> exportGiftBalanceStatement(@ModelAttribute BalanceStatementQueryReqDto reqDto);

    @PostMapping("/exportGiftBalanceStatement")
    @ApiOperation(value = "账户流水列表导出", notes = "账户流水列表导出")
    RestResponse<Object> exportGiftBalanceStatementOnPost(@RequestBody BalanceStatementQueryReqDto reqDto);

    @PostMapping("/list/sum")
    @ApiOperation(value = "账户流水汇总", notes = "账户流水汇总")
    RestResponse<BalanceStatementListSumRespDto> listSum(@RequestBody BalanceStatementQueryReqDto reqDto);
}
