package com.dtyunxi.yundt.cube.center.rebate.api.gift.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftConfigCustomerExcludeQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.ItemSkuCustomerListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags = {"赠品额度：赠品总控配置"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftConfigCustomerQueryApi",
        name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
        url = "${yundt-cube-center-rebate_api:}",
        path = "/v1/gift-config-customer"
)
public interface IGiftConfigCustomerQueryApi {

    @PostMapping("/ext/sku/page")
    @ApiOperation(value = "基础配置 - 查看(客户排除)", notes = "基础配置")
    RestResponse<PageInfo<ItemSkuCustomerListRespDto>> getSkuList(@RequestBody GiftConfigCustomerExcludeQueryReqDto excludeQueryReqDto);
}
