package com.dtyunxi.yundt.cube.center.rebate.api.gift.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.ItemSkuListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftConfigBaseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：赠品总控配置"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftConfigQueryApi",
        name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
        url = "${yundt-cube-center-rebate_api:}",
        path = "/v1/gift-config"
)
public interface IGiftConfigQueryApi {


    @GetMapping("/base/detail")
    @ApiOperation(value = "基础配置 - 查看", notes = "基础配置")
    RestResponse<GiftConfigBaseRespDto> queryBase();

    @PostMapping("/sku/page")
    @ApiOperation(value = "基础配置 - 查看", notes = "基础配置")
    RestResponse<PageInfo<ItemSkuListRespDto>> getSkuList(@RequestBody ItemSkuListQueryReqDto itemSkuListQueryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);


    @GetMapping("/base/detail/{organizationId}")
    @ApiOperation(value = "基础配置 - 根据大 B 组织id", notes = "基础配置 - 根据大 B 组织id")
    RestResponse<GiftConfigBaseRespDto> queryByOrganizationId(@PathVariable Long organizationId);

    @PostMapping("/exclude/sku/list")
    @ApiOperation(value = "查询指定经销商(店铺)需要排除的sku列表", notes = "查询指定经销商(店铺)需要排除的sku列表")
    RestResponse<Set<Long>> getExcludeSkuList(@RequestBody List<Long> skuList, @RequestParam("shopId") Long shopId);
}
