/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemOnShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftExcludeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftConfigCustomerExcludeQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftConfigCustomerExcludeReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.ItemSkuCustomerExcelRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.ItemSkuCustomerListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.ItemSkuListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftConfigQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftConfigCustomerService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.BeanUtils;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.OrganizationUtils;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.vo.GIftConfigCustomerExportVo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftConfigCustomerItemExcludeEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.StdGiftConfigCustomerItemExcludeEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftConfigCustomerItemExcludeDas;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.dto.request.ItemSkuExcludeReqDto;
import com.yx.tcbj.center.api.query.IItemCenterQueryApi;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IGiftConfigCustomerServiceImpl
implements IGiftConfigCustomerService {
    private static final Logger logger = LoggerFactory.getLogger(IGiftConfigCustomerServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private OrganizationUtils organizationUtils;
    @Resource
    private GiftConfigCustomerItemExcludeDas giftConfigCustomerItemExcludeDas;
    @Resource
    private IItemCenterQueryApi itemCenterQueryApi;
    @Resource
    private IGiftConfigQueryApi giftConfigQueryApi;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;

    @Override
    public PageInfo<ItemSkuCustomerListRespDto> getSkuList(GiftConfigCustomerExcludeQueryReqDto excludeQueryReqDto) {
        logger.info("\u5546\u54c1\u6392\u9664-\u5ba2\u6237\u6392\u9664\u5217\u8868 {}", (Object)JSONObject.toJSONString((Object)excludeQueryReqDto));
        if (!new Integer(1).equals(excludeQueryReqDto.getGiftExclude())) {
            throw new BizException("\u4e0d\u652f\u6301\u67e5\u8be2\u5df2\u6392\u9664\u5916\u4fe1\u606f\uff0cgiftExclude\u53ea\u5141\u8bb8\u4e3a1");
        }
        GiftConfigCustomerItemExcludeEo giftConfigCustomerItemExcludeEo = new GiftConfigCustomerItemExcludeEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (excludeQueryReqDto.getCustomerId() != null) {
            sqlFilters.add(SqlFilter.eq((String)"customer_id", (Object)excludeQueryReqDto.getCustomerId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)excludeQueryReqDto.getCustomerIds())) {
            List customerIds = excludeQueryReqDto.getCustomerIds().stream().distinct().collect(Collectors.toList());
            sqlFilters.add(SqlFilter.in((String)"customer_id", customerIds));
        }
        Long dealerOrgId = this.organizationUtils.getDealerOrgId(excludeQueryReqDto.getCustomerId());
        sqlFilters.add(SqlFilter.eq((String)"organization_id", (Object)dealerOrgId));
        giftConfigCustomerItemExcludeEo.setOrderByDesc("create_time");
        giftConfigCustomerItemExcludeEo.setSqlFilters(sqlFilters);
        giftConfigCustomerItemExcludeEo.setOrderBy("customer_id");
        PageInfo customerItemExcludeEoPageInfo = this.giftConfigCustomerItemExcludeDas.selectPage((BaseEo)giftConfigCustomerItemExcludeEo, excludeQueryReqDto.getPageNum(), excludeQueryReqDto.getPageSize());
        if (customerItemExcludeEoPageInfo == null || CollectionUtils.isEmpty((Collection)customerItemExcludeEoPageInfo.getList())) {
            return new PageInfo();
        }
        ItemSkuExcludeReqDto itemSkuExcludeReqDto = new ItemSkuExcludeReqDto();
        itemSkuExcludeReqDto.setInstanceId(this.context.instanceId());
        itemSkuExcludeReqDto.setPageNum(Integer.valueOf(1));
        itemSkuExcludeReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        itemSkuExcludeReqDto.setTenantId(this.context.tenantId());
        itemSkuExcludeReqDto.setOrgId(dealerOrgId);
        if (null != excludeQueryReqDto.getBusType()) {
            itemSkuExcludeReqDto.setBusType(excludeQueryReqDto.getBusType());
        } else {
            itemSkuExcludeReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        }
        itemSkuExcludeReqDto.setSkuIds(customerItemExcludeEoPageInfo.getList().stream().map(StdGiftConfigCustomerItemExcludeEo::getSkuId).collect(Collectors.toList()));
        RestResponse pageInfoRestResponse = this.itemCenterQueryApi.findItemSkuExclude(itemSkuExcludeReqDto);
        PageInfo itemOnShelfRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (Objects.isNull(itemOnShelfRespDtoPageInfo) || CollectionUtils.isEmpty((Collection)itemOnShelfRespDtoPageInfo.getList())) {
            return new PageInfo();
        }
        Set brandIds = itemOnShelfRespDtoPageInfo.getList().stream().map(ItemOnShelfRespDto::getBrandId).filter(Objects::nonNull).collect(Collectors.toSet());
        List brandRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(brandIds)) {
            brandRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.brandQueryApi.queryByIds(StringUtils.join(brandIds, (String)",")));
        }
        Map<Long, BrandRespDto> brandMap = brandRespDtos.stream().collect(Collectors.toMap(e -> e.getId(), e -> e, (e1, e2) -> e1));
        List itemSkuCustomerListRespDtos = itemOnShelfRespDtoPageInfo.getList().stream().map(bean -> {
            ItemSkuCustomerListRespDto respDto = new ItemSkuCustomerListRespDto();
            BeanUtils.copyProperties(bean, respDto);
            respDto.setId(null);
            respDto.setItemNum(Long.valueOf(Objects.nonNull(respDto.getWholesaleLimitMin()) ? respDto.getWholesaleLimitMin() : 1L));
            Map skuAttr = (Map)ObjectHelper.Json2Bean((String)respDto.getAttr(), Map.class);
            if (null != skuAttr) {
                String skuDesc = StringUtils.join(skuAttr.values(), (String)" ");
                respDto.setSkuName(skuDesc);
            } else {
                respDto.setSkuName("");
            }
            respDto.setGiftExclude(GiftExcludeEnum.EXCLUDE.getCode());
            if (brandMap.containsKey(bean.getBrandId())) {
                BrandRespDto brandRespDto = (BrandRespDto)brandMap.get(bean.getBrandId());
                respDto.setBrandName(brandRespDto.getName());
            }
            if (!"1".equals(respDto.getSubType())) {
                respDto.setGiftExclude(GiftExcludeEnum.EXCLUDE.getCode());
            }
            return respDto;
        }).collect(Collectors.toList());
        List customerIds = customerItemExcludeEoPageInfo.getList().stream().map(StdGiftConfigCustomerItemExcludeEo::getCustomerId).distinct().collect(Collectors.toList());
        List customerNameLists = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListOnPostByCustomerIds(customerIds));
        Map<Long, CustomerRespDto> customerMaps = Optional.ofNullable(customerNameLists).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(e -> e.getId(), e -> e, (e1, e2) -> e1));
        Map<Long, ItemSkuCustomerListRespDto> skuMaps = itemSkuCustomerListRespDtos.stream().collect(Collectors.toMap(e -> e.getSkuId(), e -> e, (e1, e2) -> e1));
        ArrayList customerListRespDtos = Lists.newArrayList();
        CustomerRespDto customerRespDto = null;
        ItemSkuCustomerListRespDto skuRespDto = null;
        for (GiftConfigCustomerItemExcludeEo e3 : customerItemExcludeEoPageInfo.getList()) {
            ItemSkuCustomerListRespDto respDto = new ItemSkuCustomerListRespDto();
            customerRespDto = customerMaps.get(e3.getCustomerId());
            if (customerRespDto != null) {
                respDto.setCustomerCode(customerRespDto.getCode());
                respDto.setCustomerName(customerRespDto.getName());
            }
            if ((skuRespDto = skuMaps.get(e3.getSkuId())) != null) {
                CubeBeanUtils.copyProperties((Object)respDto, (Object)skuRespDto, (boolean)false, (String[])new String[0]);
            }
            respDto.setCustomerId(e3.getCustomerId());
            respDto.setSkuId(e3.getSkuId());
            customerListRespDtos.add(respDto);
        }
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)customerItemExcludeEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        result.setList((List)customerListRespDtos);
        return result;
    }

    @Override
    public void exclude(List<GiftConfigCustomerExcludeReqDto> excludeReqDtoList) {
        logger.info("\u603b\u63a7\u914d\u7f6e_\u5ba2\u6237\u6392\u9664\u5546\u54c1 {}", (Object)JSON.toJSONString(excludeReqDtoList));
        if (CollectionUtils.isEmpty(excludeReqDtoList)) {
            throw new BizException("\u64cd\u4f5c\u5931\u8d25:\u5ba2\u6237\u6392\u9664\u5546\u54c1\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c");
        }
        for (GiftConfigCustomerExcludeReqDto reqDto : excludeReqDtoList) {
            if (reqDto.getCustomerId() != null && reqDto.getSkuId() != null && reqDto.getAction() != null) continue;
            throw new BizException("\u64cd\u4f5c\u5931\u8d25\uff1a\u5ba2\u6237id\u6216Sku Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        ArrayList<GiftConfigCustomerItemExcludeEo> delEos = new ArrayList<GiftConfigCustomerItemExcludeEo>();
        ArrayList<GiftConfigCustomerItemExcludeEo> addEos = new ArrayList<GiftConfigCustomerItemExcludeEo>();
        Map<Integer, List<GiftConfigCustomerExcludeReqDto>> excludeList = excludeReqDtoList.stream().collect(Collectors.groupingBy(GiftConfigCustomerExcludeReqDto::getAction));
        for (Map.Entry<Integer, List<GiftConfigCustomerExcludeReqDto>> entry : excludeList.entrySet()) {
            Integer action = entry.getKey();
            List<GiftConfigCustomerExcludeReqDto> excludeReqDtos = entry.getValue();
            for (GiftConfigCustomerExcludeReqDto excludeReqDto : excludeReqDtos) {
                GiftConfigCustomerItemExcludeEo excludeEo = new GiftConfigCustomerItemExcludeEo();
                excludeEo.setOrganizationId(this.organizationUtils.getCurUserOrgId());
                excludeEo.setCustomerId(excludeReqDto.getCustomerId());
                excludeEo.setSkuId(excludeReqDto.getSkuId());
                if (action.equals(0)) {
                    delEos.add(excludeEo);
                    continue;
                }
                addEos.add(excludeEo);
            }
        }
        if (addEos.size() > 0) {
            for (GiftConfigCustomerItemExcludeEo addEo : addEos) {
                if (!ObjectUtils.isEmpty((Object)this.giftConfigCustomerItemExcludeDas.selectOne((BaseEo)addEo))) continue;
                this.giftConfigCustomerItemExcludeDas.insert((BaseEo)addEo);
            }
        }
        if (delEos.size() > 0) {
            for (GiftConfigCustomerItemExcludeEo delEo : delEos) {
                this.giftConfigCustomerItemExcludeDas.deleteByExample((BaseEo)delEo);
            }
        }
    }

    @Override
    public RestResponse<ItemSkuCustomerExcelRespDto> excel(MultipartFile file) {
        ItemSkuCustomerExcelRespDto respDto = new ItemSkuCustomerExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List gIftConfigCustomerExportVoList = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), GIftConfigCustomerExportVo.class, (ImportParams)importParams);
            gIftConfigCustomerExportVoList = result.getList();
            if (CollectionUtils.isEmpty(gIftConfigCustomerExportVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        ItemSkuListQueryReqDto itemSkuListQueryReqDto = new ItemSkuListQueryReqDto();
        itemSkuListQueryReqDto.setGiftExclude(GiftExcludeEnum.ALL.getCode());
        itemSkuListQueryReqDto.setItemCodes(gIftConfigCustomerExportVoList.stream().map(e -> e.getItemCode()).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        PageInfo itemSkuPages = (PageInfo)RestResponseHelper.extractData((RestResponse)this.giftConfigQueryApi.getSkuList(itemSkuListQueryReqDto, Integer.valueOf(1), Integer.valueOf(10000)));
        Map<String, ItemSkuListRespDto> itemSkuMaps = itemSkuPages.getList().stream().collect(Collectors.toMap(ItemSkuListRespDto::getItemCode, e -> e));
        Long curUserOrgId = this.organizationUtils.getCurUserOrgId();
        List customerCodeList = gIftConfigCustomerExportVoList.stream().map(e -> e.getCustomerCode()).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setCodeInList(customerCodeList);
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        merchantIds.add(curUserOrgId);
        searchReqDto.setMerchantIds(merchantIds);
        RestResponse customerListResp = this.customerQueryApi.queryPostByList(searchReqDto);
        List customerList = (List)RestResponseHelper.extractData((RestResponse)customerListResp);
        if (CollectionUtils.isEmpty((Collection)customerList)) {
            throw new BizException("\u6240\u6709\u5ba2\u6237\u7686\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u91cd\u65b0\u5bfc\u5165\u3002");
        }
        Map<String, CustomerRespDto> customerMap = customerList.stream().collect(Collectors.toMap(e -> e.getCode(), e -> e, (e1, e2) -> e1));
        GiftConfigCustomerItemExcludeEo excludeEo = new GiftConfigCustomerItemExcludeEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"customer_id", customerList.stream().map(BaseRespDto::getId).collect(Collectors.toList())));
        excludeEo.setSqlFilters(sqlFilters);
        excludeEo.setOrganizationId(curUserOrgId);
        List existCludeEos = this.giftConfigCustomerItemExcludeDas.selectWithColumn((BaseEo)excludeEo, new String[]{"customer_id", "sku_id"});
        Set existCludeCusItemSets = Optional.ofNullable(existCludeEos).orElse(Lists.newArrayList()).stream().map(e -> e.getCustomerId() + "_" + e.getSkuId()).collect(Collectors.toSet());
        ArrayList<GIftConfigCustomerExportVo> successList = new ArrayList<GIftConfigCustomerExportVo>();
        ArrayList<GIftConfigCustomerExportVo> errorList = new ArrayList<GIftConfigCustomerExportVo>();
        HashSet<String> customerItemCodeSet = new HashSet<String>();
        CustomerRespDto customerRespDto = null;
        ItemSkuListRespDto itemSkuRespDto = null;
        GiftConfigCustomerItemExcludeEo addCusItemEo = null;
        for (GIftConfigCustomerExportVo vo : gIftConfigCustomerExportVoList) {
            StringBuilder errorMsg = new StringBuilder();
            if (StringUtils.isBlank((CharSequence)vo.getCustomerCode())) {
                errorMsg.append("\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            } else if (!customerMap.containsKey(vo.getCustomerCode())) {
                errorMsg.append("\u8be5\u5ba2\u6237\u7f16\u53f7\u7684\u5ba2\u6237\u4e0d\u5b58\u5728\uff1b");
            }
            if (StringUtils.isBlank((CharSequence)vo.getItemCode())) {
                errorMsg.append("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            } else if (!itemSkuMaps.containsKey(vo.getItemCode())) {
                errorMsg.append("\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u4e0d\u5728\u6392\u9664\u76ee\u5f55\u8303\u56f4\u5185(\u5373\u4e0d\u9700\u6392\u9664)\uff1b");
            }
            if (customerItemCodeSet.contains(vo.getCustomerCode() + "_" + vo.getItemCode())) {
                errorMsg.append("\u5ba2\u6237\u7f16\u53f7+\u5546\u54c1\u7f16\u7801\u4e0e\u5176\u4ed6\u884c\u91cd\u590d\uff0c\u5df2\u81ea\u52a8\u5ffd\u7565\u8be5\u6761\u6570\u636e\uff1b");
            } else {
                customerItemCodeSet.add(vo.getCustomerCode() + "_" + vo.getItemCode());
            }
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                itemSkuRespDto = itemSkuMaps.get(vo.getItemCode());
                customerRespDto = customerMap.get(vo.getCustomerCode());
                if (existCludeCusItemSets.contains(customerRespDto.getId() + "_" + itemSkuRespDto.getSkuId())) {
                    errorMsg.append("\u8be5\u5ba2\u6237\u7f16\u7801\u7684\u5546\u54c1\u5df2\u7ecf\u6392\u9664\uff0c\u4e0d\u9700\u518d\u6b21\u6392\u9664\uff0c\u5df2\u81ea\u52a8\u5ffd\u7565");
                } else {
                    addCusItemEo = new GiftConfigCustomerItemExcludeEo();
                    addCusItemEo.setCustomerId(customerRespDto.getId());
                    addCusItemEo.setSkuId(itemSkuRespDto.getSkuId());
                    addCusItemEo.setOrganizationId(curUserOrgId);
                    this.giftConfigCustomerItemExcludeDas.insert((BaseEo)addCusItemEo);
                    successList.add(vo);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
            errorList.add(this.excelErrorMsg(vo, errorMsg.toString()));
        }
        if (CollectionUtils.isNotEmpty(errorList)) {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
            String excelName = "cube/\u5ba2\u6237\u6392\u9664\u5546\u54c1\u5931\u8d25\u4fe1\u606f-\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, GIftConfigCustomerExportVo.class, null, (String)excelName, (String)"xls");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e4) {
                logger.error("\u5bfc\u51fa\u5ba2\u6237\u6392\u9664\u5546\u54c1\u914d\u7f6e\u8be6\u60c5\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:{}", (Object)e4.toString());
                return new RestResponse("-1", "\u5bfc\u51fa\u5ba2\u6237\u6392\u9664\u5546\u54c1\u914d\u7f6e\u8be6\u60c5\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:" + e4);
            }
        }
        respDto.setNum(Integer.valueOf(gIftConfigCustomerExportVoList.size()));
        respDto.setSuccessNum(Integer.valueOf(successList.size()));
        return new RestResponse((Object)respDto);
    }

    private List<Long> getItemExcludeSkuIds() {
        GiftConfigCustomerItemExcludeEo giftConfigCustomerItemExcludeEo = new GiftConfigCustomerItemExcludeEo();
        giftConfigCustomerItemExcludeEo.setOrganizationId(this.organizationUtils.getCurUserOrgId());
        List itemExcludeEos = this.giftConfigCustomerItemExcludeDas.select((BaseEo)giftConfigCustomerItemExcludeEo);
        ArrayList excludeSkuIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)itemExcludeEos)) {
            itemExcludeEos.forEach(eo -> excludeSkuIds.add(eo.getSkuId()));
        }
        return excludeSkuIds;
    }

    private List<GiftConfigCustomerItemExcludeEo> getItemExcludeBySkuId(Long skuId) {
        GiftConfigCustomerItemExcludeEo giftConfigCustomerItemExcludeEo = new GiftConfigCustomerItemExcludeEo();
        giftConfigCustomerItemExcludeEo.setOrganizationId(this.organizationUtils.getCurUserOrgId());
        giftConfigCustomerItemExcludeEo.setSkuId(skuId);
        List itemExcludeEos = this.giftConfigCustomerItemExcludeDas.select((BaseEo)giftConfigCustomerItemExcludeEo);
        return itemExcludeEos;
    }

    private GIftConfigCustomerExportVo excelErrorMsg(GIftConfigCustomerExportVo vo, String errorMsg) {
        vo.setErrorMsg(errorMsg);
        return vo;
    }
}

