/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordQueryGiftAmountReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceRecordDetailListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceRecordDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceRecordListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.ICommonService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftBalanceRecordService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.BeanUtils;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.OrganizationUtils;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftBalanceRecordDetailEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftBalanceRecordEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftBalanceRecordDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftBalanceRecordDetailDas;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class GiftBalanceRecordServiceImpl
implements IGiftBalanceRecordService {
    private static final Logger logger = LoggerFactory.getLogger(GiftBalanceRecordServiceImpl.class);
    @Resource
    private GiftBalanceRecordDas giftBalanceRecordDas;
    @Resource
    private GiftBalanceRecordDetailDas giftBalanceRecordDetailDas;
    @Resource
    private OrganizationUtils organizationUtils;
    @Resource
    private IContext context;
    @Resource
    private ICommonService commonService;

    @Override
    public PageInfo<BalanceRecordListRespDto> queryPage(BalanceRecordQueryReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List<Long> customerIds = this.commonService.queryCustomerIdsByCurrentUser(this.context.userId(), 2);
        logger.info("\u8d60\u9001\u8bb0\u5f55 {}", (Object)JSONObject.toJSONString((Object)reqDto));
        List respDtoList = this.giftBalanceRecordDas.queryPageByCondition(reqDto, customerIds, this.context.tenantId(), this.context.instanceId());
        return new PageInfo(respDtoList);
    }

    @Override
    @Transactional
    public void add(BalanceRecordAddReqDto addReqDto) {
        logger.info("\u65b0\u589e\u8d60\u9001\u8bb0\u5f55 {}", (Object)JSONObject.toJSONString((Object)addReqDto));
        GiftBalanceRecordEo eo = new GiftBalanceRecordEo();
        BeanUtils.copyProperties(addReqDto, eo);
        if (eo.getGiftTime() == null) {
            eo.setGiftTime(DateUtil.getSysDate());
        }
        eo.setGiftType(addReqDto.getGiftTypeEnum().getCode());
        eo.setAmountType(addReqDto.getAmountTypeEnum().getCode());
        if (!CollectionUtils.isEmpty((Collection)addReqDto.getDetails())) {
            ArrayList<GiftBalanceRecordDetailEo> dEoList = new ArrayList<GiftBalanceRecordDetailEo>();
            GiftBalanceRecordDetailEo dEo = new GiftBalanceRecordDetailEo();
            for (BalanceRecordDetailAddReqDto detailDto : addReqDto.getDetails()) {
                BeanUtils.copyProperties(detailDto, dEo);
                dEoList.add(dEo);
            }
            this.giftBalanceRecordDetailDas.insertBatch(dEoList);
        }
        this.giftBalanceRecordDas.insert((BaseEo)eo);
    }

    @Override
    public BalanceRecordDetailRespDto queryDetail(Long id) {
        logger.info("\u67e5\u8be2\u8d60\u9001\u8bb0\u5f55 {}", (Object)id);
        BalanceRecordDetailRespDto dto = new BalanceRecordDetailRespDto();
        GiftBalanceRecordEo eo = (GiftBalanceRecordEo)this.giftBalanceRecordDas.selectByPrimaryKey(id);
        BeanUtils.copyProperties(eo, dto);
        return dto;
    }

    @Override
    public PageInfo<BalanceRecordDetailListRespDto> queryPageDetail(BalanceRecordDetailQueryReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        if (reqDto.getOrganizationId() == null) {
            reqDto.setOrganizationId(this.organizationUtils.getCurUserOrgId());
        }
        logger.info("\u67e5\u8be2\u8d60\u9001\u8bb0\u5f55\u660e\u7ec6 {}", (Object)JSONObject.toJSONString((Object)reqDto));
        List respDtoList = this.giftBalanceRecordDetailDas.queryPage(reqDto, this.context.tenantId(), this.context.instanceId());
        return new PageInfo(respDtoList);
    }

    @Override
    public RestResponse<BigDecimal> queryGitfAmount(BalanceRecordQueryGiftAmountReqDto reqDto) {
        logger.info("\u67e5\u8be2\u8d60\u9001\u91d1\u989d {}", (Object)JSONObject.toJSONString((Object)reqDto));
        BigDecimal giftAmount = this.giftBalanceRecordDetailDas.queryGitfAmount(reqDto);
        return new RestResponse((Object)giftAmount);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void addList(List<BalanceRecordAddReqDto> balanceRecordAddReqDtoList) {
        logger.info("\u65b0\u589e\u8d60\u9001\u8bb0\u5f55 {}", (Object)JSONObject.toJSONString(balanceRecordAddReqDtoList));
        ArrayList<GiftBalanceRecordEo> eoList = new ArrayList<GiftBalanceRecordEo>();
        ArrayList<GiftBalanceRecordDetailEo> dEoList = new ArrayList<GiftBalanceRecordDetailEo>();
        GiftBalanceRecordEo eo = null;
        GiftBalanceRecordDetailEo dEo = null;
        for (BalanceRecordAddReqDto addReqDto : balanceRecordAddReqDtoList) {
            eo = new GiftBalanceRecordEo();
            BeanUtils.copyProperties(addReqDto, eo);
            if (eo.getGiftTime() == null) {
                eo.setGiftTime(DateUtil.getSysDate());
            }
            eo.setGiftType(addReqDto.getGiftTypeEnum().getCode());
            eo.setAmountType(Objects.nonNull(addReqDto.getAmountTypeEnum()) ? addReqDto.getAmountTypeEnum().getCode() : null);
            eoList.add(eo);
            if (CollectionUtils.isEmpty((Collection)addReqDto.getDetails())) continue;
            for (BalanceRecordDetailAddReqDto detailDto : addReqDto.getDetails()) {
                dEo = new GiftBalanceRecordDetailEo();
                BeanUtils.copyProperties(detailDto, dEo);
                dEoList.add(dEo);
            }
        }
        this.giftBalanceRecordDetailDas.insertBatch(dEoList);
        this.giftBalanceRecordDas.insertBatch(eoList);
    }

    @Override
    public List<BalanceRecordDetailRespDto> queryDetailByOrderNos(List<String> orderNos) {
        if (CollectionUtils.isEmpty(orderNos)) {
            return Lists.newArrayList();
        }
        GiftBalanceRecordDetailEo eo = new GiftBalanceRecordDetailEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"order_no", orderNos));
        eo.setSqlFilters((List)sqlFilters);
        List eos = this.giftBalanceRecordDetailDas.select((BaseEo)eo);
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)eos, BalanceRecordDetailRespDto.class);
        return respDtos;
    }
}

