/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.IncomeExpenditureEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceStatementAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceStatementQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceStatementListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceStatementListSumRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.ICommonService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.service.IGiftBalanceStatementService;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.BeanUtils;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.OrganizationUtils;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils.RandomBalanceCodeUtil;
import com.dtyunxi.yundt.cube.center.rebate.biz.gift.vo.GiftBalanceStatementExportVo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftBalanceEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.gift.GiftBalanceStatementEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftBalanceDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.gift.das.GiftBalanceStatementDas;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GiftBalanceStatementServiceImpl
implements IGiftBalanceStatementService {
    private static final Logger logger = LoggerFactory.getLogger(GiftBalanceStatementServiceImpl.class);
    @Resource
    private GiftBalanceStatementDas giftBalanceStatementDas;
    @Resource
    private OrganizationUtils organizationUtils;
    @Resource
    private IContext context;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICommonService commonService;
    @Autowired
    private GiftBalanceDas giftBalanceDas;
    @Autowired
    private ISellerQueryApi sellerQueryApi;

    @Override
    public PageInfo<BalanceStatementListRespDto> queryPage(BalanceStatementQueryReqDto reqDto) {
        boolean bool = this.handleDto(reqDto);
        if (!bool) {
            return new PageInfo();
        }
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List respDtoList = this.giftBalanceStatementDas.queryPage(reqDto, this.context.tenantId(), this.context.instanceId());
        Set organizationIdSet = respDtoList.stream().filter(s -> s.getOrganizationId() != null).map(BalanceStatementListRespDto::getOrganizationId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(organizationIdSet)) {
            SellerQueryReqDto queryReqDto = new SellerQueryReqDto();
            queryReqDto.setOrganizationIds(new ArrayList(organizationIdSet));
            List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(queryReqDto));
            Map<Long, SellerRespDto> sellerMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getOrganizationId, e -> e, (e1, e2) -> e1));
            for (BalanceStatementListRespDto respDto : respDtoList) {
                SellerRespDto sellerRespDto = sellerMap.get(respDto.getOrganizationId());
                if (sellerRespDto == null) continue;
                respDto.setShopName(sellerRespDto.getName());
            }
        }
        return new PageInfo(respDtoList);
    }

    private boolean handleDto(BalanceStatementQueryReqDto reqDto) {
        if (reqDto.getOrganizationId() == null) {
            reqDto.setOrganizationId(this.organizationUtils.getCurUserOrgId());
        }
        if (reqDto.getType() == 1) {
            RestResponse customerIdList = this.customerExtQueryApi.queryCustomerIdsByUserId(this.context.userId());
            logger.info("\u6839\u636euserId\u67e5\u8be2\u5ba2\u6237idList {}", (Object)JSON.toJSONString((Object)customerIdList.getData()));
            if (CollectionUtils.isEmpty((Collection)((Collection)customerIdList.getData()))) {
                ArrayList respDtoList = new ArrayList();
                return false;
            }
            reqDto.setCustomerIds(((List)customerIdList.getData()).stream().map(String::valueOf).collect(Collectors.joining(",")));
        } else {
            reqDto.setMerchantId(reqDto.getOrganizationId() + "");
        }
        logger.info("\u8d26\u6237\u6d41\u6c34 {}", (Object)JSONObject.toJSONString((Object)reqDto));
        return true;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void add(BalanceStatementAddReqDto addReqDto) {
        logger.info("\u65b0\u589e\u8d26\u6237\u6d41\u6c34 {}", (Object)JSONObject.toJSONString((Object)addReqDto));
        GiftBalanceStatementEo eo = new GiftBalanceStatementEo();
        BeanUtils.copyProperties(addReqDto, eo);
        eo.setTradeType(addReqDto.getTradeTypeEnum().getCode());
        eo.setIncomeExpenditure(addReqDto.getIncomeExpenditureEnum().getCode());
        eo.setTradeNo(RandomBalanceCodeUtil.getDataToNumber(6));
        if (addReqDto.getTradeTime() == null) {
            eo.setTradeTime(com.dtyunxi.util.DateUtil.getSysDate());
        }
        this.giftBalanceStatementDas.insert((BaseEo)eo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void addList(List<BalanceStatementAddReqDto> balanceStatementAddReqDtoList) {
        logger.info("\u65b0\u589e\u8d26\u6237\u6d41\u6c34 {}", (Object)JSONObject.toJSONString(balanceStatementAddReqDtoList));
        ArrayList<GiftBalanceStatementEo> eoList = new ArrayList<GiftBalanceStatementEo>();
        HashMap balanceMap = Maps.newHashMap();
        for (BalanceStatementAddReqDto addReqDto : balanceStatementAddReqDtoList) {
            GiftBalanceStatementEo eo = new GiftBalanceStatementEo();
            BeanUtils.copyProperties(addReqDto, eo);
            eo.setTradeType(addReqDto.getTradeTypeEnum().getCode());
            eo.setIncomeExpenditure(addReqDto.getIncomeExpenditureEnum().getCode());
            eo.setTradeNo(RandomBalanceCodeUtil.getDataToNumber(6));
            if (addReqDto.getBalance() == null) {
                GiftBalanceEo balanceEo;
                if (!balanceMap.containsKey(addReqDto.getCustomerId())) {
                    GiftBalanceEo giftBalanceEo = new GiftBalanceEo();
                    giftBalanceEo.setCustomerId(addReqDto.getCustomerId());
                    giftBalanceEo = (GiftBalanceEo)this.giftBalanceDas.selectOne((BaseEo)giftBalanceEo);
                    balanceMap.put(addReqDto.getCustomerId(), giftBalanceEo);
                }
                if ((balanceEo = (GiftBalanceEo)balanceMap.get(addReqDto.getCustomerId())) != null) {
                    eo.setBalance(balanceEo.getBalance());
                }
            }
            eoList.add(eo);
        }
        this.giftBalanceStatementDas.insertBatch(eoList);
    }

    @Override
    public RestResponse<Object> exportGiftBalanceStatement(BalanceStatementQueryReqDto reqDto) {
        block4: {
            PageInfo<BalanceStatementListRespDto> pageInfo = this.queryPage(reqDto);
            try {
                String exportUrl;
                if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) break block4;
                List list = pageInfo.getList();
                ArrayList rList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)rList, (Collection)list, GiftBalanceStatementExportVo.class);
                rList.stream().forEach(e -> e.setTradeType(TradeTypeEnum.toName((String)e.getTradeType())));
                String excelName = "cube/\u8d26\u6237\u6d41\u6c34-\u8ba2\u5355\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                try {
                    exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, GiftBalanceStatementExportVo.class, null, (String)excelName, (String)"xls");
                }
                catch (Exception e2) {
                    logger.error("\u5bfc\u51fa\u8d26\u6237\u6d41\u6c34-\u9519\u8bef:{}", (Object)e2.toString());
                    return new RestResponse("-1", "\u5bfc\u51fa\u8d26\u6237\u6d41\u6c34-\u9519\u8bef:" + e2);
                }
                return new RestResponse("0", "\u5bfc\u51fa\u8d26\u6237\u6d41\u6c34\u6210\u529f", (Object)exportUrl);
            }
            catch (Exception e3) {
                logger.error(e3.getMessage(), (Throwable)e3);
            }
        }
        return null;
    }

    @Override
    public BalanceStatementListSumRespDto listSum(BalanceStatementQueryReqDto reqDto) {
        BalanceStatementListSumRespDto respDto = new BalanceStatementListSumRespDto();
        boolean bool = this.handleDto(reqDto);
        if (!bool) {
            return respDto;
        }
        List list = this.giftBalanceStatementDas.listSum(reqDto);
        for (Map map : list) {
            String incomeExpenditure = String.valueOf(map.get("incomeExpenditure"));
            BigDecimal totalAmount = new BigDecimal(String.valueOf(map.get("totalAmount")));
            if (incomeExpenditure != null && ObjectUtil.equal((Object)incomeExpenditure, (Object)IncomeExpenditureEnum.EXPENDITURE.getCode())) {
                respDto.setPayAmountTotal(totalAmount);
            }
            if (incomeExpenditure == null || !ObjectUtil.equal((Object)incomeExpenditure, (Object)IncomeExpenditureEnum.INCOME.getCode())) continue;
            respDto.setIncomeAmountTotal(totalAmount);
        }
        return respDto;
    }
}

